package de.javafleet.oop;

import de.javafleet.oop.model.*;
import java.util.ArrayList;
import java.util.List;

/**
 * Einstiegspunkt für Tag 8: Typumwandlung & instanceof.
 * 
 * Demonstriert:
 * - Upcast (automatisch)
 * - Downcast (explizit)
 * - instanceof Prüfung
 * - Pattern Matching (Java 16+)
 * 
 * @author Nova Trent
 */
public class Main {
    
    public static void main(String[] args) {
        System.out.println("╔═══════════════════════════════════════════════════╗");
        System.out.println("║    Java OOP - Tag 8: Typumwandlung & instanceof   ║");
        System.out.println("╚═══════════════════════════════════════════════════╝");
        System.out.println();
        
        // ========================================
        // TEIL 1: Upcast (automatisch)
        // ========================================
        
        System.out.println("═══ TEIL 1: Upcast (automatisch) ═══");
        System.out.println();
        
        Auto auto = new Auto("VW Golf", 2024, 4);
        
        // Upcast: Auto → Fahrzeug (automatisch!)
        Fahrzeug fahrzeug = auto;  // Kein Cast nötig!
        
        System.out.println();
        System.out.println("Nach Upcast:");
        System.out.println("  fahrzeug.getMarke(): " + fahrzeug.getMarke());  // ✅ OK
        fahrzeug.fahren(10);  // ✅ OK
        // fahrzeug.hupen();  // ❌ FEHLER! Fahrzeug kennt hupen() nicht
        
        System.out.println();
        
        // ========================================
        // TEIL 2: Downcast (explizit)
        // ========================================
        
        System.out.println("═══ TEIL 2: Downcast (explizit) ═══");
        System.out.println();
        
        // Downcast: Fahrzeug → Auto (explizit!)
        Auto wiederAuto = (Auto) fahrzeug;
        wiederAuto.hupen();  // ✅ Jetzt geht's!
        
        System.out.println();
        
        // ========================================
        // TEIL 3: Gefährlicher Downcast
        // ========================================
        
        System.out.println("═══ TEIL 3: Gefährlicher Downcast ═══");
        System.out.println();
        
        Fahrzeug moto = new Motorrad("Harley", 2023, 1200, "Chopper");
        System.out.println();
        
        // Das würde CRASHEN:
        // Auto crash = (Auto) moto;  // 💥 ClassCastException!
        
        System.out.println("⚠️ Ohne Prüfung: ClassCastException!");
        System.out.println("   Auto crash = (Auto) moto;  // BOOM!");
        
        System.out.println();
        
        // ========================================
        // TEIL 4: instanceof Prüfung
        // ========================================
        
        System.out.println("═══ TEIL 4: instanceof Prüfung ═══");
        System.out.println();
        
        System.out.println("Typ-Prüfungen für 'fahrzeug' (ist Auto):");
        System.out.println("  fahrzeug instanceof Auto:      " + (fahrzeug instanceof Auto));
        System.out.println("  fahrzeug instanceof Fahrzeug:  " + (fahrzeug instanceof Fahrzeug));
        System.out.println("  fahrzeug instanceof Object:    " + (fahrzeug instanceof Object));
        System.out.println("  fahrzeug instanceof Motorrad:  " + (fahrzeug instanceof Motorrad));
        
        System.out.println();
        
        System.out.println("Typ-Prüfungen für 'moto' (ist Motorrad):");
        System.out.println("  moto instanceof Motorrad:  " + (moto instanceof Motorrad));
        System.out.println("  moto instanceof Auto:      " + (moto instanceof Auto));
        
        System.out.println();
        
        // ========================================
        // TEIL 5: Sichere Typumwandlung
        // ========================================
        
        System.out.println("═══ TEIL 5: Sichere Typumwandlung ═══");
        System.out.println();
        
        // Klassischer Ansatz:
        if (fahrzeug instanceof Auto) {
            Auto a = (Auto) fahrzeug;
            System.out.println("Klassisch: ");
            a.hupen();
        }
        
        // Pattern Matching (Java 16+):
        if (fahrzeug instanceof Auto a) {
            System.out.println("Pattern Matching:");
            a.hupen();
        }
        
        System.out.println();
        
        // ========================================
        // TEIL 6: Polymorphe Collection
        // ========================================
        
        System.out.println("═══ TEIL 6: Polymorphe Collection ═══");
        System.out.println();
        
        List<Fahrzeug> fuhrpark = new ArrayList<>();
        fuhrpark.add(new Auto("BMW", 2022, 2));
        fuhrpark.add(new Motorrad("Kawasaki", 2021, 600, "Sportler"));
        fuhrpark.add(new Auto("Audi", 2023, 4));
        
        System.out.println();
        System.out.println("Alle Fahrzeuge durchgehen:");
        for (Fahrzeug f : fuhrpark) {
            System.out.println("→ " + f.getMarke());
            f.fahren(10);
            
            // Typ-spezifische Aktionen:
            if (f instanceof Auto a) {
                a.hupen();
            }
            if (f instanceof Motorrad m) {
                m.wheelie();
            }
            System.out.println();
        }
        
        // ========================================
        // TEIL 7: Mitarbeiter-Hierarchie (Lösung Tag 7)
        // ========================================
        
        System.out.println("═══ TEIL 7: Mitarbeiter (Lösung Tag 7) ═══");
        System.out.println();
        
        List<Mitarbeiter> team = new ArrayList<>();
        team.add(new Entwickler("Max", "P1234", 5000, "Java"));
        team.add(new Manager("Anna", "P5678", 7000, 5));
        team.add(new Entwickler("Tom", "P9999", 4500, "Python"));
        
        System.out.println();
        System.out.println("Team durchgehen:");
        for (Mitarbeiter m : team) {
            System.out.println("→ " + m.getName() + " (" + m.getRolle() + ")");
            m.arbeiten();
            
            if (m instanceof Entwickler e) {
                e.coden();
            }
            if (m instanceof Manager mgr) {
                mgr.meeting();
            }
            System.out.println();
        }
        
        System.out.println("✅ Tag 8 geschafft!");
        System.out.println();
        
        // ========================================
        // AUFGABE
        // ========================================
        
        System.out.println("╔═══════════════════════════════════════════════════╗");
        System.out.println("║                  DEINE AUFGABE                    ║");
        System.out.println("╠═══════════════════════════════════════════════════╣");
        System.out.println("║ Erstelle ein Tierheim-System:                     ║");
        System.out.println("║                                                   ║");
        System.out.println("║ Abstrakte Klasse Tier:                            ║");
        System.out.println("║ - name, alter                                     ║");
        System.out.println("║ - abstract lautGeben()                            ║");
        System.out.println("║                                                   ║");
        System.out.println("║ Kindklasse Hund:                                  ║");
        System.out.println("║ - rasse, lautGeben() → \"Wuff!\", apportieren()     ║");
        System.out.println("║                                                   ║");
        System.out.println("║ Kindklasse Katze:                                 ║");
        System.out.println("║ - istFreigaenger, lautGeben() → \"Miau!\", klettern()║");
        System.out.println("║                                                   ║");
        System.out.println("║ Main: List<Tier>, instanceof für spezifische Aktionen ║");
        System.out.println("║                                                   ║");
        System.out.println("║ Lösung: Anfang Tag 9!                             ║");
        System.out.println("╚═══════════════════════════════════════════════════╝");
    }
}
