package de.javafleet.oop.model;

/**
 * Auto-Klasse — Kindklasse von Fahrzeug für Tag 6: Vererbung.
 * 
 * Demonstriert:
 * - extends für Vererbung
 * - super() für Konstruktor-Aufruf
 * - Zusätzliche Attribute und Methoden
 * - Zugriff auf protected Attribute der Elternklasse
 * 
 * @author Nova Trent
 * @version 6.0
 */
public class Auto extends Fahrzeug {
    
    // ========================================
    // ZUSÄTZLICHE ATTRIBUTE (nur für Auto)
    // ========================================
    
    /** Anzahl der Türen */
    private int anzahlTueren;
    
    /** Typ des Antriebs */
    private String antrieb;
    
    // ========================================
    // KONSTRUKTOREN
    // ========================================
    
    /**
     * Erstellt ein neues Auto.
     * 
     * @param marke Die Marke
     * @param baujahr Das Baujahr
     * @param anzahlTueren Die Anzahl der Türen (2-5)
     * @param antrieb Der Antriebstyp (z.B. "Benzin", "Diesel", "Elektro")
     */
    public Auto(String marke, int baujahr, int anzahlTueren, String antrieb) {
        // WICHTIG: super() muss erste Anweisung sein!
        super(marke, baujahr);
        
        // Validierung der Auto-spezifischen Attribute
        if (anzahlTueren < 2 || anzahlTueren > 5) {
            throw new IllegalArgumentException("Anzahl Türen muss zwischen 2 und 5 liegen!");
        }
        if (antrieb == null || antrieb.isBlank()) {
            throw new IllegalArgumentException("Antrieb darf nicht leer sein!");
        }
        
        this.anzahlTueren = anzahlTueren;
        this.antrieb = antrieb;
        
        System.out.println("  → Auto-Details: " + anzahlTueren + " Türen, " + antrieb);
    }
    
    /**
     * Erstellt ein Auto mit Standard-Antrieb (Benzin).
     */
    public Auto(String marke, int baujahr, int anzahlTueren) {
        this(marke, baujahr, anzahlTueren, "Benzin");
    }
    
    /**
     * Erstellt ein Standard-Auto (4 Türen, Benzin).
     */
    public Auto(String marke, int baujahr) {
        this(marke, baujahr, 4, "Benzin");
    }
    
    // ========================================
    // EIGENE METHODEN (nur für Auto)
    // ========================================
    
    /**
     * Das Auto hupt.
     */
    public void hupen() {
        System.out.println("🚗 HUUUP! HUUUP!");
    }
    
    /**
     * Öffnet eine bestimmte Tür.
     * 
     * @param tuerNummer Die Türnummer (1 bis anzahlTueren)
     */
    public void oeffneTuer(int tuerNummer) {
        if (tuerNummer < 1 || tuerNummer > anzahlTueren) {
            throw new IllegalArgumentException(
                "Türnummer muss zwischen 1 und " + anzahlTueren + " liegen!"
            );
        }
        System.out.println("Tür " + tuerNummer + " wird geöffnet...");
    }
    
    // ========================================
    // ÜBERSCHRIEBENE METHODEN
    // ========================================
    
    /**
     * Überschreibt die fahren()-Methode der Elternklasse.
     * Fügt Auto-spezifisches Verhalten hinzu.
     */
    @Override
    public void fahren(int km) {
        // Erst die Eltern-Methode aufrufen
        super.fahren(km);
        // Dann Auto-spezifisches Verhalten
        System.out.println("  (Das Auto schnurrt leise...)");
    }
    
    /**
     * Überschreibt die info()-Methode für Auto-spezifische Ausgabe.
     */
    @Override
    public void info() {
        System.out.println("╔════════════════════════════════════╗");
        System.out.println("║              AUTO                  ║");
        System.out.println("╠════════════════════════════════════╣");
        System.out.println("║ Marke:       " + pad(marke) + "║");
        System.out.println("║ Baujahr:     " + pad(String.valueOf(baujahr)) + "║");
        System.out.println("║ Kilometer:   " + pad(kilometerstand + " km") + "║");
        System.out.println("║ Türen:       " + pad(String.valueOf(anzahlTueren)) + "║");
        System.out.println("║ Antrieb:     " + pad(antrieb) + "║");
        System.out.println("╚════════════════════════════════════╝");
    }
    
    // ========================================
    // GETTER
    // ========================================
    
    public int getAnzahlTueren() {
        return anzahlTueren;
    }
    
    public String getAntrieb() {
        return antrieb;
    }
}
