package de.javafleet.oop.model;

/**
 * Entwickler-Klasse — Kindklasse von Mitarbeiter.
 * 
 * Demonstriert:
 * - Vererbung von abstrakter Klasse
 * - Implementierung der abstrakten Methode
 * - Überschreiben von Methoden
 * 
 * @author Nova Trent
 * @version 1.0
 */
public class Entwickler extends Mitarbeiter {
    
    // ========================================
    // ZUSÄTZLICHE ATTRIBUTE
    // ========================================
    
    private String programmiersprache;
    private String team;
    
    // ========================================
    // KONSTRUKTOR
    // ========================================
    
    public Entwickler(String name, String personalnummer, double gehalt, 
                      String programmiersprache) {
        super(name, personalnummer, gehalt);
        
        if (programmiersprache == null || programmiersprache.isBlank()) {
            throw new IllegalArgumentException("Programmiersprache darf nicht leer sein!");
        }
        
        this.programmiersprache = programmiersprache;
        this.team = "Allgemein";
        
        System.out.println("✓ Entwickler erstellt: " + name + " (" + programmiersprache + ")");
    }
    
    public Entwickler(String name, String personalnummer, double gehalt, 
                      String programmiersprache, String team) {
        this(name, personalnummer, gehalt, programmiersprache);
        this.team = team;
    }
    
    // ========================================
    // ÜBERSCHRIEBENE METHODEN
    // ========================================
    
    @Override
    public void arbeiten() {
        System.out.println(name + " programmiert in " + programmiersprache + ".");
    }
    
    @Override
    public String getRolle() {
        return "Entwickler";
    }
    
    // ========================================
    // EIGENE METHODEN
    // ========================================
    
    /**
     * Der Entwickler codet.
     */
    public void coden() {
        System.out.println("⌨️ " + name + ": Tipptipptipp... *schreibt " + programmiersprache + " Code*");
    }
    
    /**
     * Der Entwickler reviewed Code.
     */
    public void codeReview() {
        System.out.println("👀 " + name + " macht Code Review...");
    }
    
    /**
     * Der Entwickler debuggt.
     */
    public void debuggen() {
        System.out.println("🐛 " + name + " sucht nach Bugs...");
    }
    
    // ========================================
    // GETTER
    // ========================================
    
    public String getProgrammiersprache() { return programmiersprache; }
    public String getTeam() { return team; }
}
