package de.javafleet.oop.model;

/**
 * Fahrzeug-Klasse — Elternklasse für Tag 6: Vererbung.
 * 
 * Demonstriert:
 * - Basisklasse für Vererbungshierarchie
 * - protected Attribute für Kindklassen
 * - Konstruktor, der von Kindklassen mit super() aufgerufen wird
 * 
 * @author Nova Trent
 * @version 1.0
 */
public class Fahrzeug {
    
    // ========================================
    // PROTECTED ATTRIBUTE (für Kindklassen zugänglich)
    // ========================================
    
    /** Die Marke des Fahrzeugs */
    protected String marke;
    
    /** Das Baujahr */
    protected int baujahr;
    
    /** Der aktuelle Kilometerstand */
    protected int kilometerstand;
    
    // ========================================
    // KONSTRUKTOR
    // ========================================
    
    /**
     * Erstellt ein neues Fahrzeug.
     * 
     * @param marke Die Marke des Fahrzeugs
     * @param baujahr Das Baujahr
     */
    public Fahrzeug(String marke, int baujahr) {
        if (marke == null || marke.isBlank()) {
            throw new IllegalArgumentException("Marke darf nicht leer sein!");
        }
        if (baujahr < 1886 || baujahr > 2030) {
            throw new IllegalArgumentException("Baujahr muss zwischen 1886 und 2030 liegen!");
        }
        
        this.marke = marke;
        this.baujahr = baujahr;
        this.kilometerstand = 0;
        
        System.out.println("✓ Fahrzeug erstellt: " + marke + " (" + baujahr + ")");
    }
    
    // ========================================
    // METHODEN
    // ========================================
    
    /**
     * Das Fahrzeug fährt eine bestimmte Strecke.
     * Diese Methode kann von Kindklassen überschrieben werden.
     * 
     * @param km Die zu fahrenden Kilometer
     */
    public void fahren(int km) {
        if (km < 0) {
            throw new IllegalArgumentException("Kilometer dürfen nicht negativ sein!");
        }
        this.kilometerstand += km;
        System.out.println("Das Fahrzeug fährt " + km + " km.");
    }
    
    /**
     * Gibt Informationen über das Fahrzeug aus.
     */
    public void info() {
        System.out.println("╔════════════════════════════════════╗");
        System.out.println("║           FAHRZEUG                 ║");
        System.out.println("╠════════════════════════════════════╣");
        System.out.println("║ Marke:       " + pad(marke) + "║");
        System.out.println("║ Baujahr:     " + pad(String.valueOf(baujahr)) + "║");
        System.out.println("║ Kilometer:   " + pad(kilometerstand + " km") + "║");
        System.out.println("╚════════════════════════════════════╝");
    }
    
    /**
     * Berechnet das Alter des Fahrzeugs.
     * 
     * @return Das Alter in Jahren
     */
    public int getAlter() {
        return java.time.Year.now().getValue() - baujahr;
    }
    
    // ========================================
    // GETTER
    // ========================================
    
    public String getMarke() {
        return marke;
    }
    
    public int getBaujahr() {
        return baujahr;
    }
    
    public int getKilometerstand() {
        return kilometerstand;
    }
    
    // ========================================
    // HILFSMETHODEN
    // ========================================
    
    protected String pad(String s) {
        return String.format("%-21s", s);
    }
}
