package de.javafleet.oop.model;

/**
 * Manager-Klasse — Kindklasse von Mitarbeiter.
 * 
 * Demonstriert:
 * - Überschreiben von getJahresgehalt() mit Bonus
 * - Eigene Methoden für Manager
 * 
 * @author Nova Trent
 * @version 1.0
 */
public class Manager extends Mitarbeiter {
    
    // ========================================
    // KONSTANTEN
    // ========================================
    
    public static final double BONUS_PROZENT = 0.10;  // 10% Bonus
    
    // ========================================
    // ZUSÄTZLICHE ATTRIBUTE
    // ========================================
    
    private int teamgroesse;
    private String abteilung;
    
    // ========================================
    // KONSTRUKTOR
    // ========================================
    
    public Manager(String name, String personalnummer, double gehalt, 
                   int teamgroesse) {
        super(name, personalnummer, gehalt);
        
        if (teamgroesse < 0) {
            throw new IllegalArgumentException("Teamgröße darf nicht negativ sein!");
        }
        
        this.teamgroesse = teamgroesse;
        this.abteilung = "Allgemein";
        
        System.out.println("✓ Manager erstellt: " + name + " (Team: " + teamgroesse + " Personen)");
    }
    
    public Manager(String name, String personalnummer, double gehalt, 
                   int teamgroesse, String abteilung) {
        this(name, personalnummer, gehalt, teamgroesse);
        this.abteilung = abteilung;
    }
    
    // ========================================
    // ÜBERSCHRIEBENE METHODEN
    // ========================================
    
    @Override
    public void arbeiten() {
        System.out.println(name + " leitet das Team und plant Projekte.");
    }
    
    /**
     * Manager bekommen 10% Bonus auf ihr Jahresgehalt.
     */
    @Override
    public double getJahresgehalt() {
        return super.getJahresgehalt() * (1 + BONUS_PROZENT);
    }
    
    @Override
    public String getRolle() {
        return "Manager";
    }
    
    // ========================================
    // EIGENE METHODEN
    // ========================================
    
    /**
     * Der Manager ruft zum Meeting.
     */
    public void meeting() {
        System.out.println("📅 " + name + ": \"Meeting um 9 Uhr! Alle dabei?\"");
    }
    
    /**
     * Der Manager gibt Feedback.
     */
    public void feedbackGeben(String mitarbeiterName) {
        System.out.println("💬 " + name + " gibt " + mitarbeiterName + " Feedback.");
    }
    
    /**
     * Der Manager stellt jemanden ein.
     */
    public void einstellen(String neuerMitarbeiter) {
        teamgroesse++;
        System.out.println("👋 " + name + " stellt " + neuerMitarbeiter + " ein. Team: " + teamgroesse);
    }
    
    // ========================================
    // GETTER
    // ========================================
    
    public int getTeamgroesse() { return teamgroesse; }
    public String getAbteilung() { return abteilung; }
}
