package de.javafleet.oop.model;

/**
 * Abstrakte Mitarbeiter-Klasse — Lösung der Tag 7 Challenge!
 * 
 * Demonstriert:
 * - Abstrakte Klasse (kann nicht instanziiert werden)
 * - Abstrakte Methode (muss von Kindklassen implementiert werden)
 * - Template für Polymorphie
 * 
 * @author Nova Trent
 * @version 1.0
 */
public abstract class Mitarbeiter {
    
    // ========================================
    // PROTECTED ATTRIBUTE (für Kindklassen)
    // ========================================
    
    protected String name;
    protected String personalnummer;
    protected double gehalt;
    
    // ========================================
    // KONSTRUKTOR
    // ========================================
    
    public Mitarbeiter(String name, String personalnummer, double gehalt) {
        if (name == null || name.isBlank()) {
            throw new IllegalArgumentException("Name darf nicht leer sein!");
        }
        if (personalnummer == null || !personalnummer.matches("P\\d{4}")) {
            throw new IllegalArgumentException("Personalnummer muss Format 'P1234' haben!");
        }
        if (gehalt < 0) {
            throw new IllegalArgumentException("Gehalt darf nicht negativ sein!");
        }
        
        this.name = name;
        this.personalnummer = personalnummer;
        this.gehalt = gehalt;
    }
    
    // ========================================
    // NORMALE METHODEN
    // ========================================
    
    /**
     * Standard-Arbeitsverhalten. Kann überschrieben werden.
     */
    public void arbeiten() {
        System.out.println(name + " arbeitet.");
    }
    
    /**
     * Berechnet das Jahresgehalt.
     * Kann von Kindklassen überschrieben werden (z.B. für Bonus).
     */
    public double getJahresgehalt() {
        return gehalt * 12;
    }
    
    /**
     * Gibt Mitarbeiter-Info aus.
     */
    public void info() {
        System.out.println("┌─────────────────────────────────────┐");
        System.out.println("│ " + String.format("%-35s", getRolle().toUpperCase()) + " │");
        System.out.println("├─────────────────────────────────────┤");
        System.out.println("│ Name:   " + String.format("%-27s", name) + " │");
        System.out.println("│ PNR:    " + String.format("%-27s", personalnummer) + " │");
        System.out.println("│ Gehalt: " + String.format("%-27s", String.format("%.2f €/Monat", gehalt)) + " │");
        System.out.println("│ Jahr:   " + String.format("%-27s", String.format("%.2f €", getJahresgehalt())) + " │");
        System.out.println("└─────────────────────────────────────┘");
    }
    
    // ========================================
    // ABSTRAKTE METHODE
    // ========================================
    
    /**
     * Gibt die Rolle des Mitarbeiters zurück.
     * MUSS von jeder Kindklasse implementiert werden!
     */
    public abstract String getRolle();
    
    // ========================================
    // GETTER
    // ========================================
    
    public String getName() { return name; }
    public String getPersonalnummer() { return personalnummer; }
    public double getGehalt() { return gehalt; }
}
