# Java OOP - Tag 9: Interfaces & Enumerationen

**Kurs:** Java OOP – 10-Tage-Kurs  
**Tag:** 9 von 10  
**Thema:** Interfaces, implements, Enums  
**Autorin:** Nova Trent

---

## 🚀 Quick Start

```bash
cd Tag09_Interfaces_Enums
mvn compile
mvn exec:java
```

---

## 📁 Projektstruktur

```
Tag09_Interfaces_Enums/
├── pom.xml
├── README.md
└── src/main/java/
    └── de/javafleet/oop/
        ├── Main.java
        ├── model/
        │   ├── Tier.java           (Lösung Tag 8)
        │   ├── Hund.java
        │   ├── Katze.java
        │   ├── Elektroauto.java    (implements Fahrbar, Elektrisch)
        │   └── Fahrrad.java        (implements Fahrbar)
        ├── interfaces/
        │   ├── Fahrbar.java
        │   └── Elektrisch.java
        └── enums/
            ├── Status.java         (Einfaches Enum)
            └── Wochentag.java      (Enum mit Attributen)
```

---

## 📝 Was dieses Projekt demonstriert

### Interface definieren
```java
public interface Fahrbar {
    void fahren(int km);
    void bremsen();
    default void hupen() { ... }
}
```

### Interface implementieren
```java
public class Fahrrad implements Fahrbar {
    @Override
    public void fahren(int km) { ... }
    @Override
    public void bremsen() { ... }
}
```

### Mehrere Interfaces
```java
public class Elektroauto implements Fahrbar, Elektrisch {
    // Muss ALLE Methoden beider Interfaces implementieren
}
```

### Enum (einfach)
```java
public enum Status {
    AKTIV, INAKTIV, GESPERRT, GELOESCHT
}
```

### Enum (mit Attributen)
```java
public enum Wochentag {
    MONTAG("Mo", true),
    SAMSTAG("Sa", false);
    
    private final String kuerzel;
    private final boolean arbeitstag;
    
    Wochentag(String kuerzel, boolean arbeitstag) { ... }
}
```

---

## 🎯 Lernziele

- ✅ Interfaces definieren und implementieren
- ✅ Mehrere Interfaces gleichzeitig
- ✅ Default-Methoden in Interfaces
- ✅ Enums für typsichere Konstanten
- ✅ Enums mit Attributen und Methoden

---

*© 2025 Java Fleet Systems Consulting | java-developer.online*
