package de.javafleet.oop;

import de.javafleet.oop.model.*;
import de.javafleet.oop.interfaces.*;
import de.javafleet.oop.enums.*;
import java.util.ArrayList;
import java.util.List;

/**
 * Einstiegspunkt für Tag 9: Interfaces & Enumerationen.
 * 
 * Demonstriert:
 * - Interface-Implementierung
 * - Mehrere Interfaces
 * - Polymorphie mit Interfaces
 * - Enums (einfach und mit Attributen)
 * 
 * @author Nova Trent
 */
public class Main {
    
    public static void main(String[] args) {
        System.out.println("╔═══════════════════════════════════════════════════╗");
        System.out.println("║   Java OOP - Tag 9: Interfaces & Enumerationen    ║");
        System.out.println("╚═══════════════════════════════════════════════════╝");
        System.out.println();
        
        // ========================================
        // TEIL 1: Tierheim (Lösung Tag 8)
        // ========================================
        
        System.out.println("═══ TEIL 1: Tierheim (Lösung Tag 8) ═══");
        System.out.println();
        
        List<Tier> tierheim = new ArrayList<>();
        tierheim.add(new Hund("Bello", 3, "Labrador"));
        tierheim.add(new Katze("Minka", 5, true));
        tierheim.add(new Hund("Rex", 7, "Schäferhund"));
        tierheim.add(new Katze("Whiskers", 2, false));
        
        System.out.println();
        System.out.println("Alle Tiere im Tierheim:");
        for (Tier tier : tierheim) {
            tier.info();
            tier.lautGeben();
            
            // Typ-spezifische Aktionen mit instanceof
            if (tier instanceof Hund hund) {
                hund.apportieren();
            }
            if (tier instanceof Katze katze) {
                katze.klettern();
            }
            System.out.println();
        }
        
        // ========================================
        // TEIL 2: Interface implementieren
        // ========================================
        
        System.out.println("═══ TEIL 2: Interface implementieren ═══");
        System.out.println();
        
        Fahrbar.info();  // Statische Methode im Interface
        System.out.println();
        
        Fahrrad fahrrad = new Fahrrad("Mountainbike", 21);
        fahrrad.fahren(15);
        fahrrad.bremsen();
        fahrrad.hupen();  // Überschriebene Default-Methode
        
        System.out.println();
        
        // ========================================
        // TEIL 3: Mehrere Interfaces
        // ========================================
        
        System.out.println("═══ TEIL 3: Mehrere Interfaces ═══");
        System.out.println();
        
        Elektroauto tesla = new Elektroauto("Tesla Model 3");
        System.out.println();
        
        tesla.fahren(50);
        tesla.bremsen();  // Rekuperation!
        tesla.hupen();
        tesla.akkuWarnung();  // Default-Methode von Elektrisch
        
        System.out.println();
        tesla.fahren(200);
        tesla.fahren(200);
        tesla.fahren(200);
        tesla.akkuWarnung();  // Jetzt sollte Warnung kommen
        
        System.out.println();
        tesla.laden(60);
        
        System.out.println();
        
        // ========================================
        // TEIL 4: Polymorphie mit Interfaces
        // ========================================
        
        System.out.println("═══ TEIL 4: Polymorphie mit Interfaces ═══");
        System.out.println();
        
        List<Fahrbar> fuhrpark = new ArrayList<>();
        fuhrpark.add(new Fahrrad("Rennrad", 18));
        fuhrpark.add(new Elektroauto("BMW i4"));
        fuhrpark.add(new Fahrrad("Hollandrad", 3));
        
        System.out.println();
        System.out.println("Alle fahren 10 km:");
        for (Fahrbar f : fuhrpark) {
            f.fahren(10);
        }
        
        System.out.println();
        System.out.println("Alle hupen:");
        for (Fahrbar f : fuhrpark) {
            f.hupen();
        }
        
        System.out.println();
        
        // ========================================
        // TEIL 5: Einfaches Enum
        // ========================================
        
        System.out.println("═══ TEIL 5: Einfaches Enum ═══");
        System.out.println();
        
        Status benutzerStatus = Status.AKTIV;
        System.out.println("Benutzer-Status: " + benutzerStatus);
        
        // Switch mit Enum
        switch (benutzerStatus) {
            case AKTIV -> System.out.println("✅ Benutzer ist aktiv");
            case INAKTIV -> System.out.println("😴 Benutzer ist inaktiv");
            case GESPERRT -> System.out.println("🚫 Benutzer ist gesperrt");
            case GELOESCHT -> System.out.println("🗑️ Benutzer wurde gelöscht");
        }
        
        System.out.println();
        System.out.println("Alle Status-Werte:");
        for (Status s : Status.values()) {
            System.out.println("  - " + s.name() + " (Position: " + s.ordinal() + ")");
        }
        
        System.out.println();
        
        // ========================================
        // TEIL 6: Enum mit Attributen
        // ========================================
        
        System.out.println("═══ TEIL 6: Enum mit Attributen ═══");
        System.out.println();
        
        Wochentag heute = Wochentag.MITTWOCH;
        System.out.println("Heute ist: " + heute);
        System.out.println("Kürzel: " + heute.getKuerzel());
        System.out.println("Arbeitstag? " + heute.isArbeitstag());
        System.out.println("Beschreibung: " + heute.getBeschreibung());
        
        System.out.println();
        System.out.println("Alle Wochentage:");
        for (Wochentag tag : Wochentag.values()) {
            System.out.println("  " + tag.getBeschreibung());
        }
        
        System.out.println();
        System.out.println("Nur Arbeitstage:");
        for (Wochentag tag : Wochentag.values()) {
            if (tag.isArbeitstag()) {
                System.out.println("  " + tag);
            }
        }
        
        System.out.println();
        System.out.println("✅ Tag 9 geschafft!");
        System.out.println();
        
        // ========================================
        // AUFGABE
        // ========================================
        
        System.out.println("╔═══════════════════════════════════════════════════╗");
        System.out.println("║                  DEINE AUFGABE                    ║");
        System.out.println("╠═══════════════════════════════════════════════════╣");
        System.out.println("║ Erstelle ein Zahlungssystem:                      ║");
        System.out.println("║                                                   ║");
        System.out.println("║ Interface Zahlungsmittel:                         ║");
        System.out.println("║ - boolean bezahlen(double betrag)                 ║");
        System.out.println("║ - double getGuthaben()                            ║");
        System.out.println("║                                                   ║");
        System.out.println("║ Klasse Kreditkarte implements Zahlungsmittel:     ║");
        System.out.println("║ - kreditlimit, bezahlen() prüft Limit             ║");
        System.out.println("║                                                   ║");
        System.out.println("║ Klasse PayPal implements Zahlungsmittel:          ║");
        System.out.println("║ - email, guthaben                                 ║");
        System.out.println("║                                                   ║");
        System.out.println("║ Enum Waehrung: EUR, USD, GBP, CHF                 ║");
        System.out.println("║ - Attribut: symbol (\"€\", \"$\", \"£\", \"CHF\")         ║");
        System.out.println("║                                                   ║");
        System.out.println("║ Lösung: Anfang Tag 10!                            ║");
        System.out.println("╚═══════════════════════════════════════════════════╝");
    }
}
