package de.javafleet.oop.enums;

/**
 * Enum Wochentag — Enum mit Attributen und Methoden.
 * 
 * Demonstriert:
 * - Enum mit Konstruktor
 * - Enum mit Attributen
 * - Enum mit Methoden
 * 
 * @author Nova Trent
 * @version 1.0
 */
public enum Wochentag {
    
    // Enum-Werte mit Konstruktor-Argumenten
    MONTAG("Mo", true),
    DIENSTAG("Di", true),
    MITTWOCH("Mi", true),
    DONNERSTAG("Do", true),
    FREITAG("Fr", true),
    SAMSTAG("Sa", false),
    SONNTAG("So", false);
    
    // Attribute
    private final String kuerzel;
    private final boolean arbeitstag;
    
    // Konstruktor (immer private!)
    Wochentag(String kuerzel, boolean arbeitstag) {
        this.kuerzel = kuerzel;
        this.arbeitstag = arbeitstag;
    }
    
    // Getter
    public String getKuerzel() {
        return kuerzel;
    }
    
    public boolean isArbeitstag() {
        return arbeitstag;
    }
    
    // Methode
    public String getBeschreibung() {
        if (arbeitstag) {
            return kuerzel + " (Arbeitstag)";
        } else {
            return kuerzel + " (Wochenende 🎉)";
        }
    }
}
