package de.javafleet.oop.interfaces;

/**
 * Interface Elektrisch — Für alle elektrisch betriebenen Objekte.
 * 
 * @author Nova Trent
 * @version 1.0
 */
public interface Elektrisch {
    
    /**
     * Lädt das Gerät/Fahrzeug.
     * 
     * @param minuten Ladedauer in Minuten
     */
    void laden(int minuten);
    
    /**
     * Gibt den Akkustand zurück.
     * 
     * @return Akkustand in Prozent (0-100)
     */
    int getAkkustand();
    
    /**
     * Default-Methode: Zeigt Akkuwarnung.
     */
    default void akkuWarnung() {
        if (getAkkustand() < 20) {
            System.out.println("⚠️ Akku fast leer! Bitte laden.");
        }
    }
}
