package de.javafleet.oop.interfaces;

/**
 * Interface Fahrbar — Ein Vertrag für alle fahrbaren Objekte.
 * 
 * Demonstriert:
 * - Interface-Definition
 * - Abstrakte Methoden (implizit public abstract)
 * - Default-Methode
 * 
 * @author Nova Trent
 * @version 1.0
 */
public interface Fahrbar {
    
    /**
     * Fährt eine bestimmte Strecke.
     * 
     * @param km Kilometer
     */
    void fahren(int km);
    
    /**
     * Bremst das Fahrzeug.
     */
    void bremsen();
    
    /**
     * Default-Methode: Hat eine Standard-Implementierung.
     * Kann überschrieben werden, muss aber nicht.
     */
    default void hupen() {
        System.out.println("🔊 Standard-Hupe: TÖÖT!");
    }
    
    /**
     * Statische Methode im Interface.
     */
    static void info() {
        System.out.println("Interface Fahrbar — Für alle Fahrzeuge!");
    }
}
