package de.javafleet.oop.model;

import de.javafleet.oop.interfaces.Fahrbar;
import de.javafleet.oop.interfaces.Elektrisch;

/**
 * Elektroauto — Implementiert Fahrbar UND Elektrisch.
 * 
 * Demonstriert:
 * - Mehrfache Interface-Implementierung
 * - Override von Interface-Methoden
 * 
 * @author Nova Trent
 * @version 1.0
 */
public class Elektroauto implements Fahrbar, Elektrisch {
    
    private String marke;
    private int kilometerstand;
    private int akkustand;  // 0-100%
    
    public Elektroauto(String marke) {
        this.marke = marke;
        this.kilometerstand = 0;
        this.akkustand = 100;
        System.out.println("⚡ Elektroauto erstellt: " + marke);
    }
    
    // ========================================
    // FAHRBAR INTERFACE
    // ========================================
    
    @Override
    public void fahren(int km) {
        if (akkustand <= 0) {
            System.out.println("❌ Akku leer! Bitte laden.");
            return;
        }
        kilometerstand += km;
        akkustand -= km / 10;  // Pro 10km: 1% Akku
        if (akkustand < 0) akkustand = 0;
        System.out.println("⚡ " + marke + " fährt " + km + " km. Akku: " + akkustand + "%");
    }
    
    @Override
    public void bremsen() {
        akkustand += 2;  // Rekuperation!
        if (akkustand > 100) akkustand = 100;
        System.out.println("🔋 " + marke + " bremst und lädt: +" + 2 + "% Akku");
    }
    
    @Override
    public void hupen() {
        System.out.println("🔊 " + marke + ": *leises elektronisches Hupen*");
    }
    
    // ========================================
    // ELEKTRISCH INTERFACE
    // ========================================
    
    @Override
    public void laden(int minuten) {
        int geladen = minuten / 2;  // Pro 2 Min: 1%
        akkustand += geladen;
        if (akkustand > 100) akkustand = 100;
        System.out.println("🔌 " + marke + " lädt " + minuten + " Minuten: +" + geladen + "% → " + akkustand + "%");
    }
    
    @Override
    public int getAkkustand() {
        return akkustand;
    }
    
    // ========================================
    // GETTER
    // ========================================
    
    public String getMarke() { return marke; }
    public int getKilometerstand() { return kilometerstand; }
}
