package de.javafleet.oop.model;

import de.javafleet.oop.interfaces.Fahrbar;

/**
 * Fahrrad — Implementiert nur Fahrbar (nicht Elektrisch).
 * 
 * @author Nova Trent
 * @version 1.0
 */
public class Fahrrad implements Fahrbar {
    
    private String typ;
    private int gaenge;
    private int kilometerstand;
    
    public Fahrrad(String typ, int gaenge) {
        this.typ = typ;
        this.gaenge = gaenge;
        this.kilometerstand = 0;
        System.out.println("🚲 Fahrrad erstellt: " + typ + " (" + gaenge + " Gänge)");
    }
    
    @Override
    public void fahren(int km) {
        kilometerstand += km;
        System.out.println("🚲 " + typ + " fährt " + km + " km. *Strampel, strampel*");
    }
    
    @Override
    public void bremsen() {
        System.out.println("🚲 " + typ + " bremst mit Handbremse!");
    }
    
    @Override
    public void hupen() {
        System.out.println("🔔 " + typ + ": KLINGELING!");  // Überschreibt Default
    }
    
    public void gangWechseln(int gang) {
        if (gang < 1 || gang > gaenge) {
            System.out.println("❌ Ungültiger Gang! (1-" + gaenge + ")");
            return;
        }
        System.out.println("⚙️ Wechsle zu Gang " + gang);
    }
    
    public String getTyp() { return typ; }
    public int getKilometerstand() { return kilometerstand; }
}
