package de.javafleet.oop.model;

/**
 * Katze-Klasse — Kindklasse von Tier.
 * 
 * @author Nova Trent
 * @version 1.0
 */
public class Katze extends Tier {
    
    private boolean istFreigaenger;
    
    public Katze(String name, int alter, boolean istFreigaenger) {
        super(name, alter);
        this.istFreigaenger = istFreigaenger;
        System.out.println("🐈 Katze erstellt: " + name + 
            (istFreigaenger ? " (Freigänger)" : " (Wohnungskatze)"));
    }
    
    @Override
    public void lautGeben() {
        System.out.println("🐈 " + name + ": Miau!");
    }
    
    public void klettern() {
        System.out.println("🌳 " + name + " klettert auf den Baum!");
    }
    
    public void schnurren() {
        System.out.println("🐈 " + name + " schnurrt zufrieden...");
    }
    
    public boolean isFreigaenger() { return istFreigaenger; }
}
