package de.javafleet.oop.model;

/**
 * Abstrakte Tier-Klasse — Lösung der Tag 8 Challenge!
 * 
 * @author Nova Trent
 * @version 1.0
 */
public abstract class Tier {
    
    protected String name;
    protected int alter;
    
    public Tier(String name, int alter) {
        if (name == null || name.isBlank()) {
            throw new IllegalArgumentException("Name darf nicht leer sein!");
        }
        if (alter < 0) {
            throw new IllegalArgumentException("Alter darf nicht negativ sein!");
        }
        this.name = name;
        this.alter = alter;
    }
    
    /**
     * Jedes Tier gibt Laute von sich — aber unterschiedlich!
     */
    public abstract void lautGeben();
    
    public void info() {
        System.out.println("🐾 " + name + " (" + alter + " Jahre)");
    }
    
    public String getName() { return name; }
    public int getAlter() { return alter; }
}
