# Java OOP - Tag 10: Ausnahmebehandlung 🔴 FINALE

**Kurs:** Java OOP – 10-Tage-Kurs  
**Tag:** 10 von 10 — FINALE!  
**Thema:** try-catch-finally, Checked/Unchecked Exceptions, Eigene Exceptions  
**Autorin:** Nova Trent

---

## 🚀 Quick Start

```bash
cd Tag10_Ausnahmebehandlung
mvn compile
mvn exec:java
```

---

## 📁 Projektstruktur

```
Tag10_Ausnahmebehandlung/
├── pom.xml
├── README.md
└── src/main/java/
    └── de/javafleet/oop/
        ├── Main.java
        ├── model/
        │   ├── Bankkonto.java          (Exception-Demo)
        │   ├── Zahlungsmittel.java     (Lösung Tag 9)
        │   ├── Kreditkarte.java
        │   └── PayPal.java
        ├── exceptions/
        │   ├── KontoException.java     (Checked)
        │   └── UngueltigerBetragException.java (Unchecked)
        └── enums/
            └── Waehrung.java
```

---

## 📝 Was dieses Projekt demonstriert

### try-catch-finally
```java
try {
    // Riskanter Code
} catch (Exception e) {
    // Fehlerbehandlung
} finally {
    // Läuft IMMER
}
```

### Checked Exception (muss behandelt werden)
```java
public class KontoException extends Exception {
    public KontoException(String message) {
        super(message);
    }
}
```

### Unchecked Exception (optional behandeln)
```java
public class UngueltigerBetragException extends RuntimeException {
    private final double betrag;
    // ...
}
```

### throw vs. throws
```java
// throws = Deklaration
public void abheben(double betrag) throws KontoException {
    if (betrag > kontostand) {
        // throw = Werfen
        throw new KontoException("Nicht genug Guthaben!");
    }
}
```

---

## 🎯 Lernziele

- ✅ try-catch-finally verstehen
- ✅ Checked vs. Unchecked Exceptions unterscheiden
- ✅ throw vs. throws korrekt verwenden
- ✅ Eigene Exceptions erstellen
- ✅ Best Practices anwenden

---

## 🎉 KURS ABGESCHLOSSEN!

Du hast alle 10 Tage gemeistert:

| Tag | Thema | ✅ |
|-----|-------|---|
| 1 | OOP-Konzepte & erste Klasse | ✅ |
| 2 | Attribute & Methoden | ✅ |
| 3 | Datenkapselung & Sichtbarkeit | ✅ |
| 4 | Konstruktoren | ✅ |
| 5 | Konstanten & Static | ✅ |
| 6 | Vererbung – Grundlagen | ✅ |
| 7 | Polymorphie & Abstrakte Klassen | ✅ |
| 8 | Typumwandlung & instanceof | ✅ |
| 9 | Interfaces & Enumerationen | ✅ |
| 10 | Ausnahmebehandlung | ✅ |

**Du bist bereit für die echte Welt!** 🚀

---

*© 2025 Java Fleet Systems Consulting | java-developer.online*
