package de.javafleet.oop.enums;

/**
 * Enum Waehrung — Lösung der Tag 9 Challenge!
 * 
 * @author Nova Trent
 * @version 1.0
 */
public enum Waehrung {
    EUR("€"),
    USD("$"),
    GBP("£"),
    CHF("CHF");
    
    private final String symbol;
    
    Waehrung(String symbol) {
        this.symbol = symbol;
    }
    
    public String getSymbol() {
        return symbol;
    }
    
    /**
     * Formatiert einen Betrag mit Währungssymbol.
     */
    public String formatieren(double betrag) {
        return String.format("%.2f %s", betrag, symbol);
    }
}
