package de.javafleet.oop.exceptions;

/**
 * KontoException — Eigene Checked Exception für Kontofehler.
 * 
 * Erbt von Exception (nicht RuntimeException) = CHECKED!
 * Muss mit try-catch oder throws behandelt werden.
 * 
 * @author Nova Trent
 * @version 1.0
 */
public class KontoException extends Exception {
    
    /**
     * Erstellt eine KontoException mit Nachricht.
     * 
     * @param message Die Fehlermeldung
     */
    public KontoException(String message) {
        super(message);
    }
    
    /**
     * Erstellt eine KontoException mit Nachricht und Ursache.
     * 
     * @param message Die Fehlermeldung
     * @param cause Die ursprüngliche Exception
     */
    public KontoException(String message, Throwable cause) {
        super(message, cause);
    }
}
