package de.javafleet.oop.exceptions;

/**
 * UngueltigerBetragException — Eigene Unchecked Exception.
 * 
 * Erbt von RuntimeException = UNCHECKED!
 * Muss NICHT behandelt werden (aber kann).
 * 
 * Enthält zusätzlich den ungültigen Betrag für bessere Fehlermeldungen.
 * 
 * @author Nova Trent
 * @version 1.0
 */
public class UngueltigerBetragException extends RuntimeException {
    
    private final double betrag;
    
    /**
     * Erstellt eine Exception für einen ungültigen Betrag.
     * 
     * @param betrag Der ungültige Betrag
     */
    public UngueltigerBetragException(double betrag) {
        super("Ungültiger Betrag: " + betrag + "€");
        this.betrag = betrag;
    }
    
    /**
     * Erstellt eine Exception mit benutzerdefinierter Nachricht.
     * 
     * @param message Die Fehlermeldung
     * @param betrag Der ungültige Betrag
     */
    public UngueltigerBetragException(String message, double betrag) {
        super(message);
        this.betrag = betrag;
    }
    
    /**
     * Gibt den ungültigen Betrag zurück.
     * 
     * @return Der Betrag, der den Fehler verursacht hat
     */
    public double getBetrag() {
        return betrag;
    }
}
