package de.javafleet.oop.model;

/**
 * Kreditkarte — Implementiert Zahlungsmittel (Lösung Tag 9).
 * 
 * @author Nova Trent
 * @version 1.0
 */
public class Kreditkarte implements Zahlungsmittel {
    
    private final String kartennummer;
    private final double kreditlimit;
    private double genutzt;
    
    public Kreditkarte(String kartennummer, double kreditlimit) {
        this.kartennummer = kartennummer;
        this.kreditlimit = kreditlimit;
        this.genutzt = 0;
        System.out.println("💳 Kreditkarte erstellt: ****" + 
            kartennummer.substring(kartennummer.length() - 4));
    }
    
    @Override
    public boolean bezahlen(double betrag) {
        if (betrag <= 0) {
            System.out.println("❌ Betrag muss positiv sein!");
            return false;
        }
        if (genutzt + betrag > kreditlimit) {
            System.out.println("❌ Kreditlimit überschritten! Verfügbar: " + 
                (kreditlimit - genutzt) + "€");
            return false;
        }
        genutzt += betrag;
        System.out.println("✅ Kreditkarten-Zahlung: " + betrag + "€ (Limit: " + 
            (kreditlimit - genutzt) + "€ frei)");
        return true;
    }
    
    @Override
    public double getGuthaben() {
        return kreditlimit - genutzt;
    }
    
    public String getKartennummer() { return kartennummer; }
    public double getKreditlimit() { return kreditlimit; }
}
