package de.javafleet.oop.model;

/**
 * PayPal — Implementiert Zahlungsmittel (Lösung Tag 9).
 * 
 * @author Nova Trent
 * @version 1.0
 */
public class PayPal implements Zahlungsmittel {
    
    private final String email;
    private double guthaben;
    
    public PayPal(String email, double guthaben) {
        this.email = email;
        this.guthaben = guthaben;
        System.out.println("📧 PayPal erstellt: " + email);
    }
    
    @Override
    public boolean bezahlen(double betrag) {
        if (betrag <= 0) {
            System.out.println("❌ Betrag muss positiv sein!");
            return false;
        }
        if (betrag > guthaben) {
            System.out.println("❌ Nicht genug Guthaben! Verfügbar: " + guthaben + "€");
            return false;
        }
        guthaben -= betrag;
        System.out.println("✅ PayPal-Zahlung: " + betrag + "€ (Restguthaben: " + guthaben + "€)");
        return true;
    }
    
    @Override
    public double getGuthaben() {
        return guthaben;
    }
    
    public void aufladen(double betrag) {
        if (betrag > 0) {
            guthaben += betrag;
            System.out.println("💰 PayPal aufgeladen: +" + betrag + "€");
        }
    }
    
    public String getEmail() { return email; }
}
