package de.javafleet.oop.model;

/**
 * Interface Zahlungsmittel — Lösung der Tag 9 Challenge!
 * 
 * @author Nova Trent
 * @version 1.0
 */
public interface Zahlungsmittel {
    
    /**
     * Führt eine Zahlung durch.
     * 
     * @param betrag Der zu zahlende Betrag
     * @return true wenn erfolgreich, false sonst
     */
    boolean bezahlen(double betrag);
    
    /**
     * Gibt das verfügbare Guthaben zurück.
     * 
     * @return Das Guthaben
     */
    double getGuthaben();
    
    /**
     * Default-Methode: Prüft ob Zahlung möglich ist.
     */
    default boolean kannBezahlen(double betrag) {
        return betrag > 0 && betrag <= getGuthaben();
    }
}
