package de.javafleet.messaging;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.jms.annotation.EnableJms;

/**
 * MessageConsumer - Empfängt und verarbeitet Messages vom Broker
 * 
 * Dieser Service simuliert eine Lagerverwaltung, die Bestellungen
 * aus der Queue abholt und verarbeitet.
 * 
 * WICHTIG: Starte zuerst den Broker (Port 8080)!
 * 
 * @author Java Fleet Systems Consulting
 * @see <a href="https://www.java-developer.online">java-developer.online</a>
 */
@SpringBootApplication
@EnableJms  // Aktiviert JMS Listener!
public class MessageConsumerApplication {

    public static void main(String[] args) {
        System.out.println("""
            
            ╔══════════════════════════════════════════════════════════════╗
            ║                                                              ║
            ║   📥 Java Fleet Message Consumer                             ║
            ║                                                              ║
            ║   Wartet auf Messages in der Queue...                        ║
            ║   Health-Check: http://localhost:8082/api/consumer/health    ║
            ║                                                              ║
            ║   Sende eine Bestellung über den Producer:                   ║
            ║   curl "http://localhost:8081/api/orders/send?product=Laptop"║
            ║                                                              ║
            ╚══════════════════════════════════════════════════════════════╝
            
            """);
        
        SpringApplication.run(MessageConsumerApplication.class, args);
    }
}
