package de.javafleet.messaging;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

/**
 * MessageProducer - Sendet Messages an den Broker
 * 
 * Dieser Service simuliert einen Webshop, der Bestellungen
 * als Messages an eine Queue sendet.
 * 
 * WICHTIG: Starte zuerst den Broker (Port 8080)!
 * 
 * @author Java Fleet Systems Consulting
 * @see <a href="https://www.java-developer.online">java-developer.online</a>
 */
@SpringBootApplication
public class MessageProducerApplication {

    public static void main(String[] args) {
        System.out.println("""
            
            ╔══════════════════════════════════════════════════════════════╗
            ║                                                              ║
            ║   📤 Java Fleet Message Producer                             ║
            ║                                                              ║
            ║   REST-API:  http://localhost:8081/api/orders                ║
            ║   Swagger:   http://localhost:8081/swagger-ui.html           ║
            ║                                                              ║
            ║   Teste mit:                                                 ║
            ║   curl "http://localhost:8081/api/orders/send?product=Laptop"║
            ║                                                              ║
            ╚══════════════════════════════════════════════════════════════╝
            
            """);
        
        SpringApplication.run(MessageProducerApplication.class, args);
    }
}
