package de.javafleet.messaging;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

/**
 * MyMessageBroker - Der zentrale Message Broker
 * 
 * Dieser Service startet einen eingebetteten ActiveMQ Broker,
 * der Messages zwischen Producer und Consumer vermittelt.
 * 
 * Starte diesen Service ZUERST, bevor du Producer oder Consumer startest!
 * 
 * @author Java Fleet Systems Consulting
 * @see <a href="https://www.java-developer.online">java-developer.online</a>
 */
@SpringBootApplication
public class MessageBrokerApplication {

    public static void main(String[] args) {
        System.out.println("""
            
            ╔══════════════════════════════════════════════════════════════╗
            ║                                                              ║
            ║   🚀 Java Fleet Message Broker                               ║
            ║                                                              ║
            ║   ActiveMQ läuft auf: tcp://localhost:61616                  ║
            ║   Web-Console:        http://localhost:8080                  ║
            ║                                                              ║
            ║   Starte jetzt Producer (Port 8081) und Consumer (Port 8082) ║
            ║                                                              ║
            ╚══════════════════════════════════════════════════════════════╝
            
            """);
        
        SpringApplication.run(MessageBrokerApplication.class, args);
    }
}
