package de.javafleet.messaging;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.scheduling.annotation.EnableAsync;

/**
 * SpringMailService - Email-Versand mit Spring Boot
 * 
 * Dieser Service demonstriert Email-Versand mit:
 * - Einfache Text-Emails
 * - HTML-Emails mit Thymeleaf Templates
 * - Asynchronen Email-Versand mit @Async
 * 
 * WICHTIG: Starte MailDev vorher!
 * docker run -p 1080:1080 -p 1025:1025 maildev/maildev
 * 
 * @author Java Fleet Systems Consulting
 * @see <a href="https://www.java-developer.online">java-developer.online</a>
 */
@SpringBootApplication
@EnableAsync  // Aktiviert asynchronen Email-Versand!
@ComponentScan(basePackages = "de.javafleet.*")
public class SpringMailServiceApplication {

    public static void main(String[] args) {
        System.out.println("""
            
            ╔══════════════════════════════════════════════════════════════╗
            ║                                                              ║
            ║   📧 Java Fleet Spring Mail Service                          ║
            ║                                                              ║
            ║   REST-API:  http://localhost:8083/api/email                 ║
            ║   MailDev:   http://localhost:1080                           ║
            ║                                                              ║
            ║   Starte zuerst MailDev:                                     ║
            ║   docker run -p 1080:1080 -p 1025:1025 maildev/maildev       ║
            ║                                                              ║
            ║   Teste mit:                                                 ║
            ║   curl "http://localhost:8083/api/email/send?to=test@test.de"║
            ║                                                              ║
            ╚══════════════════════════════════════════════════════════════╝
            
            """);
        
        SpringApplication.run(SpringMailServiceApplication.class, args);
    }
}
