package com.javafleet.demo;

import com.javafleet.greeting.GreetingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;

/**
 * Demo-Anwendung für den Greeting Spring Boot Starter.
 * 
 * <p>Zeigt die automatische Bean-Erstellung durch den Starter.</p>
 * 
 * <h2>Testen:</h2>
 * <pre>
 * # Anwendung starten
 * mvn spring-boot:run
 * 
 * # REST-Endpunkt testen
 * curl http://localhost:8080/greet/Franz
 * curl http://localhost:8080/greet/Nova
 * </pre>
 */
@SpringBootApplication
public class DemoApplication {

    private static final Logger log = LoggerFactory.getLogger(DemoApplication.class);

    public static void main(String[] args) {
        SpringApplication.run(DemoApplication.class, args);
    }

    /**
     * CommandLineRunner für Konsolen-Demo beim Start.
     * 
     * <p>Zeigt, dass der {@link GreetingService} automatisch injiziert wird,
     * ohne dass wir ihn selbst erstellen müssen!</p>
     */
    @Bean
    CommandLineRunner demo(GreetingService greetingService) {
        return args -> {
            log.info("========================================");
            log.info("  Greeting Starter Demo");
            log.info("========================================");
            
            // Test 1: Default-Name
            log.info("Test 1: {}", greetingService.greet("Franz"));
            
            // Test 2: Anderer Name
            log.info("Test 2: {}", greetingService.greet("Nova"));
            
            // Test 3: Noch ein Name
            log.info("Test 3: {}", greetingService.greet("Elyndra"));
            
            log.info("========================================");
            log.info("  REST-Endpunkt: http://localhost:8080/greet/{name}");
            log.info("========================================");
        };
    }
}
