package com.javafleet.demo;

import com.javafleet.greeting.GreetingService;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;

import static org.assertj.core.api.Assertions.assertThat;

/**
 * Integration Tests für die Demo-Anwendung.
 * 
 * <p>Testet dass der Starter korrekt in eine echte Spring Boot Anwendung
 * integriert wird.</p>
 */
@SpringBootTest
@DisplayName("DemoApplication Integration Tests")
class DemoApplicationTest {

    @Autowired
    private GreetingService greetingService;

    @Test
    @DisplayName("Context sollte laden")
    void contextLoads() {
        // Wenn wir hier ankommen, hat der Context erfolgreich geladen
    }

    @Test
    @DisplayName("GreetingService sollte autowired werden")
    void greetingServiceShouldBeAutowired() {
        assertThat(greetingService).isNotNull();
    }

    @Test
    @DisplayName("GreetingService sollte funktionieren")
    void greetingServiceShouldWork() {
        String result = greetingService.greet("Test");
        assertThat(result).contains("Test");
    }
}
