package com.javafleet.demo;

import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.web.servlet.MockMvc;

import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

/**
 * Web-Layer Tests für {@link GreetingController}.
 * 
 * <p>Testet die REST-Endpunkte mit MockMvc.</p>
 */
@SpringBootTest
@AutoConfigureMockMvc
@DisplayName("GreetingController Web Tests")
class GreetingControllerTest {

    @Autowired
    private MockMvc mockMvc;

    @Nested
    @DisplayName("GET /greet/{name}")
    class GreetWithName {

        @Test
        @DisplayName("sollte 200 OK zurückgeben")
        void shouldReturn200OK() throws Exception {
            mockMvc.perform(get("/greet/Franz"))
                    .andExpect(status().isOk());
        }

        @Test
        @DisplayName("sollte korrekte Begrüßung zurückgeben")
        void shouldReturnCorrectGreeting() throws Exception {
            mockMvc.perform(get("/greet/Franz"))
                    .andExpect(status().isOk())
                    .andExpect(content().string("Hello, Franz!"));
        }

        @Test
        @DisplayName("sollte verschiedene Namen verarbeiten")
        void shouldHandleDifferentNames() throws Exception {
            mockMvc.perform(get("/greet/Nova"))
                    .andExpect(content().string("Hello, Nova!"));

            mockMvc.perform(get("/greet/Elyndra"))
                    .andExpect(content().string("Hello, Elyndra!"));
        }

        @Test
        @DisplayName("sollte URL-kodierte Namen verarbeiten")
        void shouldHandleUrlEncodedNames() throws Exception {
            mockMvc.perform(get("/greet/Franz-Martin"))
                    .andExpect(content().string("Hello, Franz-Martin!"));
        }
    }

    @Nested
    @DisplayName("GET /greet")
    class GreetWorld {

        @Test
        @DisplayName("sollte 200 OK zurückgeben")
        void shouldReturn200OK() throws Exception {
            mockMvc.perform(get("/greet"))
                    .andExpect(status().isOk());
        }

        @Test
        @DisplayName("sollte 'World' als Default begrüßen")
        void shouldGreetWorldByDefault() throws Exception {
            mockMvc.perform(get("/greet"))
                    .andExpect(content().string("Hello, World!"));
        }
    }
}
