package com.javafleet.greeting;

/**
 * Service für Begrüßungen.
 * 
 * <p>Dieses Interface definiert den Vertrag für Greeting-Implementierungen.
 * Der Spring Boot Starter stellt automatisch eine Default-Implementierung bereit,
 * die über {@code application.properties} konfigurierbar ist.</p>
 * 
 * <h2>Verwendung:</h2>
 * <pre>{@code
 * @Autowired
 * private GreetingService greetingService;
 * 
 * String message = greetingService.greet("World");
 * // Output: "Hello, World!"
 * }</pre>
 * 
 * <h2>Konfiguration:</h2>
 * <pre>
 * greeting.message=Guten Tag
 * greeting.uppercase=true
 * greeting.prefix=[VIP]
 * </pre>
 * 
 * @author Java Fleet Systems Consulting
 * @since 1.0.0
 * @see DefaultGreetingService
 * @see GreetingProperties
 */
public interface GreetingService {
    
    /**
     * Erstellt eine Begrüßung für den angegebenen Namen.
     * 
     * <p>Die Formatierung der Begrüßung wird durch die konfigurierten
     * {@link GreetingProperties} bestimmt.</p>
     * 
     * @param name Der zu begrüßende Name (darf nicht {@code null} sein)
     * @return Die formatierte Begrüßung, niemals {@code null}
     * @throws IllegalArgumentException wenn {@code name} null oder leer ist
     */
    String greet(String name);
}
