package com.javafleet.greeting;

import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import static org.assertj.core.api.Assertions.assertThat;

/**
 * Unit Tests für {@link GreetingProperties}.
 * 
 * <p>Testet Default-Werte und Setter/Getter-Funktionalität.</p>
 */
@DisplayName("GreetingProperties")
class GreetingPropertiesTest {

    @Nested
    @DisplayName("Default Values")
    class DefaultValues {

        @Test
        @DisplayName("message sollte 'Hello' sein")
        void messageShouldDefaultToHello() {
            GreetingProperties props = new GreetingProperties();
            assertThat(props.getMessage()).isEqualTo("Hello");
        }

        @Test
        @DisplayName("uppercase sollte false sein")
        void uppercaseShouldDefaultToFalse() {
            GreetingProperties props = new GreetingProperties();
            assertThat(props.isUppercase()).isFalse();
        }

        @Test
        @DisplayName("prefix sollte leer sein")
        void prefixShouldDefaultToEmpty() {
            GreetingProperties props = new GreetingProperties();
            assertThat(props.getPrefix()).isEmpty();
        }

        @Test
        @DisplayName("enabled sollte true sein")
        void enabledShouldDefaultToTrue() {
            GreetingProperties props = new GreetingProperties();
            assertThat(props.isEnabled()).isTrue();
        }

        @Test
        @DisplayName("format sollte nicht null sein")
        void formatShouldNotBeNull() {
            GreetingProperties props = new GreetingProperties();
            assertThat(props.getFormat()).isNotNull();
        }
    }

    @Nested
    @DisplayName("Format Default Values")
    class FormatDefaultValues {

        @Test
        @DisplayName("emoji sollte leer sein")
        void emojiShouldDefaultToEmpty() {
            GreetingProperties.Format format = new GreetingProperties.Format();
            assertThat(format.getEmoji()).isEmpty();
        }

        @Test
        @DisplayName("separator sollte ', ' sein")
        void separatorShouldDefaultToCommaSpace() {
            GreetingProperties.Format format = new GreetingProperties.Format();
            assertThat(format.getSeparator()).isEqualTo(", ");
        }

        @Test
        @DisplayName("suffix sollte '!' sein")
        void suffixShouldDefaultToExclamation() {
            GreetingProperties.Format format = new GreetingProperties.Format();
            assertThat(format.getSuffix()).isEqualTo("!");
        }
    }

    @Nested
    @DisplayName("Setter & Getter")
    class SettersAndGetters {

        @Test
        @DisplayName("setMessage sollte Wert speichern")
        void setMessageShouldStoreValue() {
            GreetingProperties props = new GreetingProperties();
            props.setMessage("Guten Tag");
            assertThat(props.getMessage()).isEqualTo("Guten Tag");
        }

        @Test
        @DisplayName("setUppercase sollte Wert speichern")
        void setUppercaseShouldStoreValue() {
            GreetingProperties props = new GreetingProperties();
            props.setUppercase(true);
            assertThat(props.isUppercase()).isTrue();
        }

        @Test
        @DisplayName("setPrefix sollte Wert speichern")
        void setPrefixShouldStoreValue() {
            GreetingProperties props = new GreetingProperties();
            props.setPrefix("[VIP]");
            assertThat(props.getPrefix()).isEqualTo("[VIP]");
        }

        @Test
        @DisplayName("setEnabled sollte Wert speichern")
        void setEnabledShouldStoreValue() {
            GreetingProperties props = new GreetingProperties();
            props.setEnabled(false);
            assertThat(props.isEnabled()).isFalse();
        }

        @Test
        @DisplayName("Format-Setter sollte Werte speichern")
        void formatSettersShouldStoreValues() {
            GreetingProperties.Format format = new GreetingProperties.Format();
            format.setEmoji("👋");
            format.setSeparator(" -> ");
            format.setSuffix("?");

            assertThat(format.getEmoji()).isEqualTo("👋");
            assertThat(format.getSeparator()).isEqualTo(" -> ");
            assertThat(format.getSuffix()).isEqualTo("?");
        }
    }

    @Nested
    @DisplayName("toString()")
    class ToStringTests {

        @Test
        @DisplayName("toString sollte alle Felder enthalten")
        void toStringShouldContainAllFields() {
            GreetingProperties props = new GreetingProperties();
            props.setMessage("Test");
            props.setUppercase(true);
            props.setPrefix("[PRE]");
            
            String result = props.toString();
            
            assertThat(result)
                .contains("message='Test'")
                .contains("uppercase=true")
                .contains("prefix='[PRE]'")
                .contains("enabled=true");
        }

        @Test
        @DisplayName("Format.toString sollte alle Felder enthalten")
        void formatToStringShouldContainAllFields() {
            GreetingProperties.Format format = new GreetingProperties.Format();
            format.setEmoji("🎉");
            
            String result = format.toString();
            
            assertThat(result)
                .contains("emoji='🎉'")
                .contains("separator=', '")
                .contains("suffix='!'");
        }
    }
}
