# 🖥️ Java Anwendungsentwicklung - Tag 1

**Die Desktop-Ära: Warum GUIs?**

*Java Fleet Systems Consulting - java-developer.online*

---

## 📋 Was ist das?

Das Starter-Projekt für **Tag 1** des Kurses "Java Anwendungsentwicklung".

Heute geht es um **Theorie und Einordnung**:
- Warum gibt es Desktop-GUIs?
- Was ist Swing? Was ist JavaFX?
- Warum sind sie heute "Legacy"?
- Wann machen sie trotzdem noch Sinn?

Das Projekt enthält ein einfaches **"Hallo Swing"**-Programm, damit du siehst, wie ein GUI-Projekt aussieht.

---

## 🚀 Quick Start

### Voraussetzungen

- ✅ JDK 21 (Amazon Corretto oder OpenJDK)
- ✅ Maven 3.9+
- ✅ NetBeans 22 (oder andere IDE)

### In der Kommandozeile

```bash
# 1. In das Projekt-Verzeichnis wechseln
cd java-anwendungsentwicklung-tag1

# 2. Projekt bauen
mvn clean compile

# 3. Anwendung starten
mvn exec:java
```

### In NetBeans

1. **File → Open Project**
2. Das Verzeichnis `java-anwendungsentwicklung-tag1` auswählen
3. Rechtsklick auf Projekt → **Run**

### In IntelliJ IDEA

1. **File → Open**
2. Die `pom.xml` auswählen und als Projekt öffnen
3. `HalloSwing.java` öffnen und den grünen Play-Button klicken

---

## 📁 Projektstruktur

```
java-anwendungsentwicklung-tag1/
├── pom.xml                          # Maven Konfiguration
├── README.md                        # Diese Datei
└── src/
    └── main/
        └── java/
            └── de/
                └── javafleet/
                    └── gui/
                        └── HalloSwing.java   # Hauptklasse
```

---

## 🎓 Was du lernst

### In diesem Projekt:

1. **JFrame** - Das Hauptfenster einer Swing-Anwendung
2. **JPanel** - Container für andere Komponenten
3. **JLabel, JButton, JTextArea** - Basis-Komponenten
4. **ActionListener** - Event-Handling (das Observer-Pattern!)
5. **Look-and-Feel** - Das Aussehen anpassen
6. **SwingUtilities.invokeLater()** - Thread-Safety in Swing

### Im Blogpost (Tag 1):

- Die Geschichte von AWT → Swing → JavaFX → Web
- Warum Swing "Legacy" ist (und was das bedeutet)
- Wann Desktop-Apps heute noch Sinn machen
- Warum du das trotzdem lernen solltest

---

## 🔧 Konfiguration

### Look-and-Feel ändern

In `HalloSwing.java`, Methode `setzeLookAndFeel()`:

```java
// Option 1: FlatLaf Dark (Standard in diesem Projekt)
UIManager.setLookAndFeel(new FlatDarkLaf());

// Option 2: FlatLaf Light
UIManager.setLookAndFeel(new FlatLightLaf());

// Option 3: System Look-and-Feel (Windows/Mac)
UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());

// Option 4: Nimbus (Java's "moderner" Look)
UIManager.setLookAndFeel("javax.swing.plaf.nimbus.NimbusLookAndFeel");
```

---

## ❓ Probleme?

### "Java nicht gefunden"

```bash
# Prüfe Java-Version
java -version

# Sollte ausgeben: openjdk version "21.x.x" oder ähnlich
```

Falls nicht: [JDK 21 installieren](https://adoptium.net/)

### "Maven nicht gefunden"

```bash
# Prüfe Maven-Version
mvn -version
```

Falls nicht: [Maven installieren](https://maven.apache.org/install.html)

### "FlatLaf nicht gefunden"

Maven lädt die Dependency automatisch. Falls nicht:

```bash
mvn dependency:resolve
```

---

## 📚 Weiterführende Links

- [Blogpost Tag 1](https://java-developer.online/java-anwendungsentwicklung-tag-1)
- [Oracle Swing Tutorial](https://docs.oracle.com/javase/tutorial/uiswing/)
- [FlatLaf GitHub](https://github.com/JFormDesigner/FlatLaf)

---

## 📞 Fragen?

- **Kurs:** franz-martin@java-developer.online
- **Technisch:** support@java-developer.online

---

*© 2025 Java Fleet Systems Consulting | java-developer.online*
