# 🖥️ Java Anwendungsentwicklung - Tag 2

**AWT & Swing Grundlagen - Komponenten und erste Fenster**

*Java Fleet Systems Consulting - java-developer.online*

---

## 📋 Was ist das?

Das Projekt für **Tag 2** des Kurses "Java Anwendungsentwicklung".

Heute wird es praktisch! Du lernst:
- Ein Fenster mit JFrame erstellen
- Die wichtigsten Swing-Komponenten kennen
- Ein funktionierendes Formular bauen
- Den Event Dispatch Thread (EDT) verstehen

---

## 🚀 Quick Start

### Voraussetzungen

- ✅ JDK 21 (Amazon Corretto oder OpenJDK)
- ✅ Maven 3.9+
- ✅ NetBeans 22 (oder andere IDE)

### Demos starten

```bash
# 1. Komponenten-Demo (Standard)
mvn exec:java

# 2. Erstes JFrame
mvn exec:java -Phallo

# 3. Mini-Formular
mvn exec:java -Pformular
```

### In NetBeans

1. **File → Open Project**
2. Das Verzeichnis `java-anwendungsentwicklung-tag2` auswählen
3. Gewünschte Klasse öffnen → Rechtsklick → **Run File**

---

## 📁 Projektstruktur

```
java-anwendungsentwicklung-tag2/
├── pom.xml
├── README.md
└── src/
    └── main/
        └── java/
            └── de/
                └── javafleet/
                    └── gui/
                        ├── HalloJFrame.java      # Das absolute Minimum
                        ├── KomponentenDemo.java  # Alle Komponenten
                        └── MiniFormular.java     # Praktisches Beispiel
```

---

## 📚 Die drei Demos

### 1. HalloJFrame.java - Das Minimum

Das absolute Minimum für ein Swing-Fenster:
- JFrame erstellen und konfigurieren
- `setDefaultCloseOperation()` verstehen
- `SwingUtilities.invokeLater()` - WARUM das Pflicht ist!

**Starten:** `mvn exec:java -Phallo`

### 2. KomponentenDemo.java - Alle Komponenten

Eine interaktive Tour durch alle wichtigen Swing-Komponenten:

| Tab | Komponenten |
|-----|-------------|
| 📝 Text | JLabel, JTextField, JPasswordField, JTextArea |
| 🔘 Auswahl | JButton, JCheckBox, JRadioButton, JToggleButton |
| 📋 Listen | JComboBox, JList |
| 📊 Slider | JSlider, JProgressBar, JSpinner |

**Starten:** `mvn exec:java` (Standard)

### 3. MiniFormular.java - Praktisches Beispiel

Ein vollständiges Registrierungsformular mit:
- Validierung der Eingaben
- Passwort-Bestätigung
- Fehler-Feedback
- Sauberer Code-Struktur (init → layout → actions → frame)

**Starten:** `mvn exec:java -Pformular`

---

## 🎓 Was du lernst

### Kernkonzepte Tag 2

1. **JFrame** - Das Hauptfenster
   - `setDefaultCloseOperation()`
   - `setSize()` vs `pack()`
   - `setLocationRelativeTo(null)` für Bildschirmmitte

2. **Swing-Komponenten** (alle mit J!)
   - JLabel, JButton, JTextField
   - JCheckBox, JRadioButton (mit ButtonGroup!)
   - JComboBox, JList
   - JSlider, JProgressBar, JSpinner

3. **Event Dispatch Thread (EDT)**
   - WARUM `SwingUtilities.invokeLater()` Pflicht ist
   - Swing ist NICHT thread-safe!
   - Race Conditions vermeiden

4. **Best Practices**
   - Komponenten als Felder (für späteren Zugriff)
   - Saubere Methoden-Struktur
   - Validierung VOR Verarbeitung

---

## 🔧 Look-and-Feel ändern

Das Projekt nutzt **FlatLaf Dark** für ein modernes Aussehen.

In jeder Klasse kannst du das ändern:

```java
// FlatLaf Dark (Standard)
UIManager.setLookAndFeel(new FlatDarkLaf());

// FlatLaf Light
UIManager.setLookAndFeel(new FlatLightLaf());

// System Look-and-Feel
UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());

// Nimbus
UIManager.setLookAndFeel("javax.swing.plaf.nimbus.NimbusLookAndFeel");
```

---

## ❓ Probleme?

### "Komponente reagiert nicht"

Hast du `SwingUtilities.invokeLater()` verwendet? Ohne den EDT können seltsame Bugs auftreten.

### "Layout sieht komisch aus"

Hast du `pack()` nach dem Hinzufügen aller Komponenten aufgerufen?

### "ButtonGroup funktioniert nicht"

RadioButtons müssen einer ButtonGroup hinzugefügt werden:
```java
ButtonGroup group = new ButtonGroup();
group.add(radio1);
group.add(radio2);
```

---

## 📚 Weiterführende Links

- [Blogpost Tag 2](https://java-developer.online/java-anwendungsentwicklung-tag-2)
- [Oracle Swing Tutorial](https://docs.oracle.com/javase/tutorial/uiswing/)
- [FlatLaf Demo](https://www.formdev.com/flatlaf/)

---

## 📞 Fragen?

- **Kurs:** franz-martin@java-developer.online
- **Technisch:** support@java-developer.online

---

*© 2025 Java Fleet Systems Consulting | java-developer.online*
