package de.javafleet.gui;

import com.formdev.flatlaf.FlatDarkLaf;
import javax.swing.*;

/**
 * HalloJFrame - Das absolute Minimum für ein Swing-Fenster.
 * 
 * Tag 2 des Kurses "Java Anwendungsentwicklung"
 * Java Fleet Systems Consulting - java-developer.online
 * 
 * Was du hier lernst:
 * 1. JFrame erstellen und konfigurieren
 * 2. Warum SwingUtilities.invokeLater() PFLICHT ist
 * 3. Die wichtigsten JFrame-Methoden
 * 
 * @author Franz-Martin (CTO, Java Fleet Systems Consulting)
 */
public class HalloJFrame {
    
    public static void main(String[] args) {
        /*
         * ══════════════════════════════════════════════════════════════
         * WICHTIG: SwingUtilities.invokeLater()
         * ══════════════════════════════════════════════════════════════
         * 
         * Swing ist NICHT thread-safe!
         * 
         * Das bedeutet: Wenn du GUI-Code aus dem main-Thread ausführst,
         * während der Event Dispatch Thread (EDT) auch auf die GUI zugreift,
         * bekommst du Race Conditions.
         * 
         * Das Fiese: Diese Bugs treten MANCHMAL auf. Nicht immer.
         * Auf deinem Rechner läuft alles. Beim Kunden crasht es.
         * 
         * LÖSUNG: IMMER invokeLater() verwenden!
         * 
         * Das stellt den Code in die EDT-Queue und garantiert,
         * dass er im richtigen Thread ausgeführt wird.
         */
        SwingUtilities.invokeLater(() -> {
            // Look-and-Feel setzen (BEVOR Komponenten erstellt werden!)
            try {
                UIManager.setLookAndFeel(new FlatDarkLaf());
            } catch (Exception e) {
                System.err.println("FlatLaf konnte nicht geladen werden.");
            }
            
            erstelleFenster();
        });
    }
    
    private static void erstelleFenster() {
        /*
         * ══════════════════════════════════════════════════════════════
         * SCHRITT 1: JFrame erstellen
         * ══════════════════════════════════════════════════════════════
         * 
         * JFrame ist das Hauptfenster deiner Anwendung.
         * Es hat:
         * - Eine Titelleiste (mit Titel, Min/Max/Close Buttons)
         * - Einen ContentPane (wo deine Komponenten reinkommen)
         * - Optionale Menüleiste
         */
        JFrame frame = new JFrame("Mein erstes JFrame");
        
        /*
         * ══════════════════════════════════════════════════════════════
         * SCHRITT 2: Close-Operation festlegen
         * ══════════════════════════════════════════════════════════════
         * 
         * Was passiert, wenn der User das Fenster schließt?
         * 
         * Optionen:
         * - EXIT_ON_CLOSE      → Anwendung beendet (System.exit)
         * - DISPOSE_ON_CLOSE   → Nur dieses Fenster schließen
         * - HIDE_ON_CLOSE      → Fenster verstecken (Standard)
         * - DO_NOTHING_ON_CLOSE → Nichts tun (für eigene Dialoge)
         */
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        
        /*
         * ══════════════════════════════════════════════════════════════
         * SCHRITT 3: Größe festlegen
         * ══════════════════════════════════════════════════════════════
         * 
         * Zwei Möglichkeiten:
         * 
         * A) Feste Größe:
         *    frame.setSize(800, 600);
         * 
         * B) Automatisch basierend auf Inhalt:
         *    frame.pack();
         * 
         * pack() ist meist besser, aber wir brauchen erst Inhalt.
         */
        frame.setSize(500, 400);
        
        /*
         * ══════════════════════════════════════════════════════════════
         * SCHRITT 4: Position festlegen
         * ══════════════════════════════════════════════════════════════
         * 
         * setLocationRelativeTo(null) → Bildschirmmitte
         * setLocationRelativeTo(andereFenster) → Relativ zu anderem Fenster
         * setLocation(x, y) → Absolute Position
         */
        frame.setLocationRelativeTo(null);
        
        /*
         * ══════════════════════════════════════════════════════════════
         * SCHRITT 5: Inhalt hinzufügen (optional hier)
         * ══════════════════════════════════════════════════════════════
         * 
         * Ein einfaches Label zur Demonstration:
         */
        JLabel label = new JLabel(
            "<html><center>" +
            "<h2>🎉 Hallo Swing!</h2>" +
            "<p>Dies ist dein erstes JFrame.</p>" +
            "<p style='color: #66BB6A;'>Es funktioniert!</p>" +
            "</center></html>",
            SwingConstants.CENTER
        );
        frame.add(label);
        
        /*
         * ══════════════════════════════════════════════════════════════
         * SCHRITT 6: Fenster sichtbar machen
         * ══════════════════════════════════════════════════════════════
         * 
         * WICHTIG: setVisible(true) IMMER als LETZTES aufrufen!
         * 
         * Warum? Weil alles, was du danach änderst, ein Neuzeichnen
         * auslöst. Das ist ineffizient und kann flackern.
         */
        frame.setVisible(true);
        
        /*
         * ══════════════════════════════════════════════════════════════
         * WEITERE NÜTZLICHE METHODEN (nicht im Beispiel verwendet):
         * ══════════════════════════════════════════════════════════════
         * 
         * frame.setResizable(false);     // Größenänderung verbieten
         * frame.setAlwaysOnTop(true);    // Immer im Vordergrund
         * frame.setUndecorated(true);    // Ohne Titelleiste (für Splashscreens)
         * frame.setMinimumSize(new Dimension(400, 300));
         * frame.setMaximumSize(new Dimension(1200, 800));
         * frame.setIconImage(icon);      // Anwendungs-Icon setzen
         */
    }
}
