package com.javafleet.springboot.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Custom Annotation für Performance-Messung
 * 
 * Verwendung:
 * <pre>
 * {@code
 * @Timed
 * public Person createPerson(Person person) {
 *     // ...
 * }
 * }
 * </pre>
 * 
 * Der PerformanceAspect misst automatisch die Ausführungszeit!
 * 
 * @see com.javafleet.springboot.aspect.PerformanceAspect
 */
@Target(ElementType.METHOD)  // Nur auf Methoden anwendbar
@Retention(RetentionPolicy.RUNTIME)  // Zur Laufzeit verfügbar (wichtig für AOP!)
public @interface Timed {
    // Keine Parameter nötig
}
