package com.javafleet.springboot.service;

import com.javafleet.springboot.model.Person;
import java.util.List;

/**
 * PersonService Interface
 * 
 * Definiert die Geschäftslogik für Person-Verwaltung.
 * Verschiedene Implementierungen möglich (InMemory, Database, Cached)
 */
public interface PersonService {
    
    /**
     * Alle Personen abrufen
     * @return Liste aller Personen
     */
    List<Person> getAllPersons();
    
    /**
     * Person anhand ID abrufen
     * @param id Person-ID
     * @return Person oder null
     */
    Person getPersonById(Long id);
    
    /**
     * Neue Person erstellen
     * @param person Person-Objekt
     * @return Gespeicherte Person mit ID
     */
    Person createPerson(Person person);
    
    /**
     * Person aktualisieren
     * @param person Aktualisierte Person
     * @return Aktualisierte Person oder null
     */
    Person updatePerson(Person person);
    
    /**
     * Person löschen
     * @param id Person-ID
     */
    void deletePerson(Long id);
}
