# DevOps Admin Shell – Vollständiges Beispiel

Ein vollständiges DevOps-Admin-Tool mit Spring Shell.

**Blogpost:** [Spring Shell Deep-Dive (Teil 2)](https://java-developer.online) auf java-developer.online

## Features

✅ Health Checks für alle Services  
✅ Deployments mit Bestätigung  
✅ Rollbacks zur vorherigen Version  
✅ Log-Abfragen  
✅ Custom Prompt mit Environment-Anzeige  
✅ Farbiger Prompt (grün/gelb/rot)  
✅ Availability-Checks für gefährliche Commands  

## Quick Start

```bash
# Bauen
./mvnw clean package

# Starten
java -jar target/devops-admin-shell-1.0.0.jar

# Oder direkt mit Maven
./mvnw spring-boot:run
```

## Verfügbare Commands

### Service-Verwaltung

| Command | Beschreibung |
|---------|--------------|
| `services` | Listet alle registrierten Services |
| `service-info <name>` | Details zu einem Service |
| `health-check` | Prüft Health aller Services |
| `health-check --service <name>` | Prüft einzelnen Service |
| `logs <service> --lines 50` | Zeigt Logs |
| `logs <service> --errors-only` | Nur Fehler |

### Deployments

| Command | Beschreibung |
|---------|--------------|
| `deploy <service> --version 2.0` | Deployment |
| `deploy-prod <service> --version 2.0 --confirm` | Production mit Bestätigung |
| `rollback <service>` | Rollback |
| `deploy-history` | Zeigt Verlauf |

### Environment

| Command | Beschreibung |
|---------|--------------|
| `use-env staging` | Wechselt Environment |
| `current-env` | Zeigt aktuelles Environment |
| `list-envs` | Zeigt alle Environments |

### System

| Command | Beschreibung |
|---------|--------------|
| `status` | System-Status |
| `sysinfo` | System-Informationen |
| `commands` | Command-Übersicht |
| `help <command>` | Hilfe zu einem Command |

## Projekt-Struktur

```
src/main/java/online/javadeveloper/devopsadmin/
├── DevOpsAdminApplication.java
├── commands/
│   ├── ServiceCommands.java      # services, health-check, logs
│   ├── DeployCommands.java       # deploy, rollback
│   ├── EnvironmentCommands.java  # use-env, current-env
│   └── SystemCommands.java       # status, sysinfo
├── config/
│   ├── CustomPromptProvider.java # Farbiger Prompt
│   └── EnvironmentHolder.java    # Aktuelles Environment
└── service/
    ├── ServiceRegistry.java      # Service-Verwaltung
    ├── ServiceInfo.java          # Service-Daten
    ├── HealthChecker.java        # Health Checks
    └── DeploymentService.java    # Deployment-Logik
```

## Custom Prompt

Der Prompt zeigt das aktuelle Environment und färbt sich entsprechend:

- 🟢 **dev**: Grün
- 🟡 **staging**: Gelb  
- 🔴 **production**: Rot + Fett

```
[staging] devops-admin:> use-env production
✅ Environment gewechselt zu: production

⚠️  ACHTUNG: Du arbeitest jetzt in PRODUCTION!

[production] devops-admin:>   ← Jetzt rot!
```

## Tests ausführen

```bash
./mvnw test
```

## Native Image (Optional)

Mit GraalVM:

```bash
# GraalVM muss installiert sein
./mvnw -Pnative native:compile

# Starten (viel schneller!)
./target/devops-admin-shell
```

## Für CI/CD nutzen

```bash
# Non-Interactive Mode
java -jar devops-admin-shell.jar \
  --spring.shell.interactive.enabled=false \
  health-check

# Oder mit Spring Properties
java -jar devops-admin-shell.jar \
  deploy user-service --version 2.0.0
```

## Lizenz

MIT License – Frei verwendbar.

---

**Autor:** Code Sentinel, Java Fleet Systems Consulting  
**Kontakt:** code-sentinel@java-developer.online

© 2025 Java Fleet Systems Consulting | java-developer.online
