package online.javadeveloper.devopsadmin;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

/**
 * DevOps Admin Shell - Ein vollständiges CLI-Tool mit Spring Shell
 * 
 * Features:
 * - Health Checks für alle Services
 * - Deployment-Automation
 * - Log-Abfragen
 * - Custom Prompt mit Environment-Anzeige
 * 
 * Starten mit: ./mvnw spring-boot:run
 * 
 * Blogpost: "Spring Shell Deep-Dive" auf java-developer.online
 * 
 * © 2025 Java Fleet Systems Consulting
 */
@SpringBootApplication
public class DevOpsAdminApplication {

    public static void main(String[] args) {
        SpringApplication.run(DevOpsAdminApplication.class, args);
    }
}
