package online.javadeveloper.devopsadmin.config;

import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;
import org.springframework.shell.jline.PromptProvider;
import org.springframework.stereotype.Component;

/**
 * Custom Prompt Provider für die Shell.
 * 
 * Zeigt das aktuelle Environment an und färbt den Prompt:
 * - dev: grün
 * - staging: gelb
 * - production: rot + fett
 */
@Component
public class CustomPromptProvider implements PromptProvider {

    private final EnvironmentHolder environmentHolder;

    public CustomPromptProvider(EnvironmentHolder environmentHolder) {
        this.environmentHolder = environmentHolder;
    }

    @Override
    public AttributedString getPrompt() {
        String env = environmentHolder.getCurrent();
        String prompt = "[" + env + "] devops-admin:> ";

        AttributedStyle style = switch (env) {
            case "production" -> AttributedStyle.DEFAULT
                    .foreground(AttributedStyle.RED)
                    .bold();
            case "staging" -> AttributedStyle.DEFAULT
                    .foreground(AttributedStyle.YELLOW);
            case "dev" -> AttributedStyle.DEFAULT
                    .foreground(AttributedStyle.GREEN);
            default -> AttributedStyle.DEFAULT
                    .foreground(AttributedStyle.WHITE);
        };

        return new AttributedString(prompt, style);
    }
}
