package online.javadeveloper.devopsadmin.config;

import org.springframework.stereotype.Component;

import java.util.Set;

/**
 * Hält das aktuell ausgewählte Environment.
 * Wird für Custom Prompt und Default-Werte verwendet.
 */
@Component
public class EnvironmentHolder {

    private static final Set<String> VALID_ENVIRONMENTS = Set.of("dev", "staging", "production");
    
    private String current = "staging";

    public String getCurrent() {
        return current;
    }

    public boolean setCurrent(String environment) {
        if (!VALID_ENVIRONMENTS.contains(environment)) {
            return false;
        }
        this.current = environment;
        return true;
    }

    public Set<String> getValidEnvironments() {
        return VALID_ENVIRONMENTS;
    }

    public boolean isProduction() {
        return "production".equals(current);
    }
}
