# Java Erweiterte Techniken – Tag 2: Sets & Maps

**Kurs:** Java Erweiterte Techniken (Kurs 3 von 4)  
**Thema:** Collections – Sets & Maps (HashSet, HashMap, equals/hashCode)  
**Autor:** Java Fleet Systems Consulting  
**Version:** 1.0.0

---

## 🚀 Quick Start

### Voraussetzungen

- **JDK 21** (empfohlen: Amazon Corretto)
- **NetBeans** (oder andere IDE)
- **Maven** (in NetBeans integriert)

### Projekt öffnen

1. ZIP entpacken
2. In NetBeans: Datei → Projekt öffnen → Ordner auswählen
3. `Main.java` ausführen (Rechtsklick → Run File)

---

## 📁 Projektstruktur

```
tag02-sets-maps-starter/
├── pom.xml
├── README.md
└── src/
    ├── main/java/de/javafleet/collections/
    │   ├── Main.java                    # Einstiegspunkt
    │   ├── Person.java                  # ✅ Mit equals/hashCode
    │   ├── PersonOhneEquals.java        # ❌ Ohne equals/hashCode
    │   ├── EqualsHashCodeProblem.java   # Demo: Das Problem
    │   ├── EqualsHashCodeLoesung.java   # Demo: Die Lösung
    │   ├── SetDemo.java                 # HashSet, LinkedHashSet, TreeSet
    │   ├── MapDemo.java                 # HashMap, TreeMap
    │   ├── SortierungDemo.java          # Comparable, Comparator
    │   ├── Student.java                 # 🎨 DEINE CHALLENGE!
    │   └── StudentChallenge.java        # Test für deine Lösung
    └── test/java/de/javafleet/collections/
        └── StudentTest.java             # JUnit-Tests
```

---

## 📚 Lernziele

Nach diesem Tag kannst du:

- ✅ HashSet, LinkedHashSet und TreeSet unterscheiden und anwenden
- ✅ HashMap, LinkedHashMap und TreeMap unterscheiden und anwenden
- ✅ **equals() und hashCode() korrekt überschreiben**
- ✅ Erklären, warum equals/hashCode zusammengehören
- ✅ Comparable und Comparator für Sortierung einsetzen
- ✅ Die richtige Collection für deinen Use Case wählen

---

## 🎨 Challenge: Student-Klasse

Deine Aufgabe ist es, die `Student.java` zu implementieren!

### Level 1 (🟢 Einsteiger)
- Implementiere `equals()` und `hashCode()`
- Zwei Studenten sind gleich bei gleicher Matrikelnummer
- Geschätzte Zeit: 15-30 Minuten

### Level 2 (🟡 Fortgeschritten)
- Implementiere `Comparable<Student>`
- Sortiere nach Nachname, dann Vorname
- Geschätzte Zeit: 15-30 Minuten

### Level 3 (🔵 Profi)
- Erstelle einen `Comparator` für Sortierung nach Note
- Implementiere `toString()`
- Geschätzte Zeit: 15-30 Minuten

---

## 💡 Tipps

### Von Elyndra:
> "Der häufigste Bug: equals() überschrieben, aber hashCode() vergessen.
> Dann funktioniert HashSet nicht. IMMER beide zusammen!"

### Von Jamal:
> "In Production verwende ich zu 90% HashMap. TreeMap nur wenn ich
> wirklich nach Key sortieren muss – und das ist selten."

### Von Nova:
> "Ich hab ewig nicht verstanden, warum mein Set Duplikate hatte.
> Die Lösung: equals/hashCode. Das ist DER Aha-Moment dieses Kurses!"

---

## 🔗 Weiterführende Ressourcen

- [Blogpost: Sets & Maps](https://java-developer.online/collections-sets-maps)
- [Oracle: equals und hashCode](https://docs.oracle.com/javase/tutorial/java/IandI/objectclass.html)
- [Baeldung: Java Map Guide](https://www.baeldung.com/java-hashmap)

---

## ❓ Probleme?

### "TreeSet wirft ClassCastException"
Deine Klasse implementiert `Comparable` nicht! Füge hinzu:
```java
public class Student implements Comparable<Student> {
    @Override
    public int compareTo(Student other) {
        // Vergleichslogik
    }
}
```

### "HashSet findet mein Element nicht"
Prüfe ob `equals()` UND `hashCode()` überschrieben sind!
Beide müssen dieselben Felder verwenden.

---

## 📅 Nächster Tag

**Tag 3: Generics**
- Eigene generische Klassen
- Type Parameters
- Bounded Type Parameters
- Wildcards

---

*© 2025 Java Fleet Systems Consulting | java-developer.online*
