package de.javafleet.collections;

import java.util.HashSet;
import java.util.Set;

/**
 * Die Lösung: equals/hashCode korrekt überschrieben
 * 
 * Diese Demo zeigt, wie es funktioniert, wenn eine Klasse
 * equals() und hashCode() korrekt überschreibt.
 */
public class EqualsHashCodeLoesung {
    
    public static void demo() {
        System.out.println("--- Person (MIT equals/hashCode) ---");
        
        // Zwei Personen mit gleichen Werten erstellen
        Person max1 = new Person("Max", "Müller");
        Person max2 = new Person("Max", "Müller");
        
        // equals() Vergleich
        System.out.println("max1.equals(max2): " + max1.equals(max2));
        // Jetzt: true! ✓
        
        // hashCode() Vergleich
        System.out.println("max1.hashCode(): " + max1.hashCode());
        System.out.println("max2.hashCode(): " + max2.hashCode());
        // Jetzt: gleich! ✓
        
        // In einem HashSet
        Set<Person> personen = new HashSet<>();
        personen.add(max1);
        personen.add(max2);  // Wird als Duplikat erkannt!
        
        System.out.println("personen.size(): " + personen.size());
        // Jetzt: 1 ✓
        
        System.out.println("✓ LÖSUNG: Nur ein 'Max Müller' im Set!");
        System.out.println("   Java erkennt das Duplikat korrekt.");
        
        // Bonus: contains() funktioniert auch!
        Person maxGesucht = new Person("Max", "Müller");
        System.out.println();
        System.out.println("personen.contains(new Person(\"Max\", \"Müller\")): " 
            + personen.contains(maxGesucht));
        // true! ✓
    }
}
