package de.javafleet.collections;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

/**
 * Map-Demo: HashMap, LinkedHashMap, TreeMap
 * 
 * Diese Demo zeigt die wichtigsten Map-Operationen
 * und die Unterschiede der Implementierungen.
 */
public class MapDemo {
    
    public static void demo() {
        System.out.println("--- Map-Grundlagen mit HashMap ---");
        
        // Map erstellen: Name -> Alter
        Map<String, Integer> alter = new HashMap<>();
        
        // Einträge hinzufügen
        alter.put("Max", 25);
        alter.put("Anna", 30);
        alter.put("Tom", 22);
        
        System.out.println("Map: " + alter);
        
        // Wert abrufen
        System.out.println("Alter von Anna: " + alter.get("Anna"));  // 30
        System.out.println("Alter von Lisa: " + alter.get("Lisa"));  // null
        
        // getOrDefault - Standardwert wenn nicht vorhanden
        int lisaAlter = alter.getOrDefault("Lisa", 0);
        System.out.println("getOrDefault(\"Lisa\", 0): " + lisaAlter);
        
        // Key überschreiben
        System.out.println();
        System.out.println("Überschreiben:");
        alter.put("Max", 26);  // Neuer Wert!
        System.out.println("Nach put(\"Max\", 26): " + alter.get("Max"));
        
        // putIfAbsent - nur wenn nicht vorhanden
        alter.putIfAbsent("Max", 99);  // Wird ignoriert
        alter.putIfAbsent("Lisa", 28); // Wird hinzugefügt
        System.out.println("Nach putIfAbsent: " + alter);
        
        // Durch Map iterieren
        System.out.println();
        System.out.println("Iteration mit entrySet():");
        for (Map.Entry<String, Integer> entry : alter.entrySet()) {
            System.out.println("  " + entry.getKey() + " ist " + entry.getValue() + " Jahre alt");
        }
        
        // forEach mit Lambda
        System.out.println();
        System.out.println("forEach mit Lambda:");
        alter.forEach((name, age) -> System.out.println("  " + name + ": " + age));
        
        // Map-Implementierungen im Vergleich
        System.out.println();
        System.out.println("--- Map-Implementierungen im Vergleich ---");
        
        Map<String, Integer> hashMap = new HashMap<>();
        Map<String, Integer> linkedHashMap = new LinkedHashMap<>();
        Map<String, Integer> treeMap = new TreeMap<>();
        
        // Gleiche Daten einfügen
        String[] namen = {"Max", "Anna", "Tom", "Lisa"};
        int[] werte = {25, 30, 22, 28};
        for (int i = 0; i < namen.length; i++) {
            hashMap.put(namen[i], werte[i]);
            linkedHashMap.put(namen[i], werte[i]);
            treeMap.put(namen[i], werte[i]);
        }
        
        System.out.println("HashMap:       " + hashMap);       // Unvorhersehbar
        System.out.println("LinkedHashMap: " + linkedHashMap); // Einfüge-Reihenfolge
        System.out.println("TreeMap:       " + treeMap);       // Nach Key sortiert
    }
}
