package de.javafleet.collections;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;

/**
 * Set-Demo: HashSet, LinkedHashSet, TreeSet
 * 
 * Diese Demo zeigt die Unterschiede zwischen den drei
 * wichtigsten Set-Implementierungen.
 */
public class SetDemo {
    
    public static void demo() {
        System.out.println("--- Set-Implementierungen im Vergleich ---");
        
        // Die gleichen Daten in verschiedene Sets
        String[] sprachen = {"Java", "Python", "Kotlin", "Go", "Rust"};
        
        // 1. HashSet - keine garantierte Reihenfolge
        Set<String> hashSet = new HashSet<>();
        for (String s : sprachen) hashSet.add(s);
        System.out.println("HashSet:       " + hashSet);
        // Reihenfolge ist unvorhersehbar!
        
        // 2. LinkedHashSet - Einfüge-Reihenfolge
        Set<String> linkedHashSet = new LinkedHashSet<>();
        for (String s : sprachen) linkedHashSet.add(s);
        System.out.println("LinkedHashSet: " + linkedHashSet);
        // Reihenfolge wie eingefügt: Java, Python, Kotlin, Go, Rust
        
        // 3. TreeSet - sortiert
        Set<String> treeSet = new TreeSet<>();
        for (String s : sprachen) treeSet.add(s);
        System.out.println("TreeSet:       " + treeSet);
        // Alphabetisch sortiert: Go, Java, Kotlin, Python, Rust
        
        System.out.println();
        System.out.println("Duplikate werden ignoriert:");
        hashSet.add("Java");  // Duplikat
        hashSet.add("java");  // Kein Duplikat! (Case-sensitive)
        System.out.println("Nach add(\"Java\") und add(\"java\"): " + hashSet);
        
        System.out.println();
        System.out.println("Wichtige Methoden:");
        System.out.println("contains(\"Python\"): " + hashSet.contains("Python"));
        System.out.println("size(): " + hashSet.size());
        System.out.println("isEmpty(): " + hashSet.isEmpty());
    }
}
