package de.javafleet.collections;

import java.util.Comparator;
import java.util.Objects;

/**
 * 🎨 CHALLENGE: Student-Klasse – MUSTERLÖSUNG
 * 
 * Diese Datei enthält die komplette Implementierung aller Level.
 * Versuche zuerst selbst zu lösen, bevor du hier spickst! 😉
 * 
 * @author Java Fleet Systems Consulting
 */
public class Student implements Comparable<Student> {
    
    private int matrikelnummer;
    private String vorname;
    private String nachname;
    private double note;
    
    /**
     * Level 3 BONUS: Comparator für Sortierung nach Note
     * (beste Note = 1.0 zuerst)
     */
    public static final Comparator<Student> NACH_NOTE = 
        Comparator.comparingDouble(Student::getNote);
    
    /**
     * Bonus: Comparator nach Note absteigend (schlechteste zuerst)
     */
    public static final Comparator<Student> NACH_NOTE_DESC = 
        Comparator.comparingDouble(Student::getNote).reversed();
    
    public Student(int matrikelnummer, String vorname, String nachname, double note) {
        this.matrikelnummer = matrikelnummer;
        this.vorname = vorname;
        this.nachname = nachname;
        this.note = note;
    }
    
    // Getter
    public int getMatrikelnummer() {
        return matrikelnummer;
    }
    
    public String getVorname() {
        return vorname;
    }
    
    public String getNachname() {
        return nachname;
    }
    
    public double getNote() {
        return note;
    }
    
    /**
     * Level 1: equals() - MUSTERLÖSUNG
     * 
     * Zwei Studenten sind gleich, wenn ihre Matrikelnummer gleich ist.
     */
    @Override
    public boolean equals(Object o) {
        // 1. Identitätsprüfung
        if (this == o) return true;
        
        // 2. Null-Check und Typ-Check
        if (o == null || getClass() != o.getClass()) return false;
        
        // 3. Cast und Feldvergleich
        Student student = (Student) o;
        return matrikelnummer == student.matrikelnummer;
    }
    
    /**
     * Level 1: hashCode() - MUSTERLÖSUNG
     * 
     * Basiert auf denselben Feldern wie equals() → nur matrikelnummer!
     */
    @Override
    public int hashCode() {
        return Objects.hash(matrikelnummer);
        // Alternative: return Integer.hashCode(matrikelnummer);
    }
    
    /**
     * Level 2: compareTo() - MUSTERLÖSUNG
     * 
     * Sortiert nach Nachname, dann Vorname (alphabetisch).
     */
    @Override
    public int compareTo(Student other) {
        // Erst nach Nachname
        int nachnameCompare = this.nachname.compareTo(other.nachname);
        if (nachnameCompare != 0) {
            return nachnameCompare;
        }
        // Bei gleichem Nachnamen: nach Vorname
        return this.vorname.compareTo(other.vorname);
    }
    
    /**
     * Level 3: toString() - MUSTERLÖSUNG
     * 
     * Format: "Max Müller (12345) - Note: 1.7"
     */
    @Override
    public String toString() {
        return vorname + " " + nachname + " (" + matrikelnummer + ") - Note: " + note;
    }
}
