package de.javafleet.collections;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

import static org.junit.jupiter.api.Assertions.*;

/**
 * Tests für die Student Challenge
 * 
 * Führe diese Tests aus um deine Implementierung zu prüfen!
 */
class StudentTest {
    
    private Student student1;
    private Student student1Duplicate;
    private Student student2;
    
    @BeforeEach
    void setUp() {
        student1 = new Student(12345, "Max", "Müller", 1.7);
        student1Duplicate = new Student(12345, "Maximilian", "Mueller", 2.0);
        student2 = new Student(67890, "Anna", "Schmidt", 1.3);
    }
    
    @Nested
    @DisplayName("Level 1: equals und hashCode")
    class Level1Tests {
        
        @Test
        @DisplayName("equals() erkennt gleiche Matrikelnummer")
        void testEqualsGleicheMatrikelnummer() {
            assertTrue(student1.equals(student1Duplicate),
                "Studenten mit gleicher Matrikelnummer sollten gleich sein");
        }
        
        @Test
        @DisplayName("equals() unterscheidet verschiedene Matrikelnummern")
        void testEqualsVerschiedeneMatrikelnummer() {
            assertFalse(student1.equals(student2),
                "Studenten mit verschiedener Matrikelnummer sollten ungleich sein");
        }
        
        @Test
        @DisplayName("equals() ist reflexiv")
        void testEqualsReflexiv() {
            assertTrue(student1.equals(student1),
                "Ein Student sollte sich selbst gleichen");
        }
        
        @Test
        @DisplayName("equals() ist symmetrisch")
        void testEqualsSymmetrisch() {
            assertEquals(student1.equals(student1Duplicate), 
                         student1Duplicate.equals(student1),
                "equals() sollte symmetrisch sein");
        }
        
        @Test
        @DisplayName("equals() mit null gibt false")
        void testEqualsNull() {
            assertFalse(student1.equals(null),
                "equals(null) sollte false sein");
        }
        
        @Test
        @DisplayName("hashCode() ist konsistent mit equals()")
        void testHashCodeKonsistenz() {
            if (student1.equals(student1Duplicate)) {
                assertEquals(student1.hashCode(), student1Duplicate.hashCode(),
                    "Gleiche Objekte müssen gleichen hashCode haben!");
            }
        }
        
        @Test
        @DisplayName("HashSet erkennt Duplikate")
        void testHashSetDuplikate() {
            Set<Student> studenten = new HashSet<>();
            studenten.add(student1);
            studenten.add(student1Duplicate);
            studenten.add(student2);
            
            assertEquals(2, studenten.size(),
                "HashSet sollte nur 2 Studenten enthalten (Duplikat erkannt)");
        }
        
        @Test
        @DisplayName("HashSet.contains() funktioniert")
        void testHashSetContains() {
            Set<Student> studenten = new HashSet<>();
            studenten.add(student1);
            
            assertTrue(studenten.contains(student1Duplicate),
                "contains() sollte true sein für gleiche Matrikelnummer");
        }
    }
    
    @Nested
    @DisplayName("Level 2: Comparable")
    class Level2Tests {
        
        @Test
        @DisplayName("Student implementiert Comparable")
        void testImplementsComparable() {
            assertTrue(student1 instanceof Comparable,
                "Student sollte Comparable implementieren");
        }
        
        @Test
        @DisplayName("TreeSet sortiert nach Nachname")
        void testTreeSetSortierung() {
            try {
                Set<Student> sortiert = new TreeSet<>();
                sortiert.add(new Student(1, "Tom", "Müller", 2.0));
                sortiert.add(new Student(2, "Anna", "Schmidt", 1.3));
                sortiert.add(new Student(3, "Lisa", "Bauer", 2.3));
                
                Student[] array = sortiert.toArray(new Student[0]);
                
                assertEquals("Bauer", array[0].getNachname(),
                    "Erster Student sollte 'Bauer' sein");
                assertEquals("Müller", array[1].getNachname(),
                    "Zweiter Student sollte 'Müller' sein");
                assertEquals("Schmidt", array[2].getNachname(),
                    "Dritter Student sollte 'Schmidt' sein");
                    
            } catch (ClassCastException e) {
                fail("Student implementiert Comparable nicht!");
            }
        }
    }
    
    @Nested
    @DisplayName("Level 3: toString und Comparator")
    class Level3Tests {
        
        @Test
        @DisplayName("toString() enthält alle Infos")
        void testToString() {
            String str = student1.toString();
            
            assertTrue(str.contains("Max") || str.contains("12345"),
                "toString() sollte Name oder Matrikelnummer enthalten");
        }
    }
}
