package de.javafleet.collections;

import java.util.HashSet;
import java.util.Set;

/**
 * Das Problem: equals/hashCode nicht überschrieben
 * 
 * Diese Demo zeigt, was passiert, wenn eine Klasse
 * equals() und hashCode() NICHT überschreibt.
 */
public class EqualsHashCodeProblem {
    
    public static void demo() {
        System.out.println("--- PersonOhneEquals (OHNE equals/hashCode) ---");
        
        // Zwei Personen mit gleichen Werten erstellen
        PersonOhneEquals max1 = new PersonOhneEquals("Max", "Müller");
        PersonOhneEquals max2 = new PersonOhneEquals("Max", "Müller");
        
        // equals() Vergleich
        System.out.println("max1.equals(max2): " + max1.equals(max2));
        // Erwartung: true (gleiche Werte!)
        // Realität: false (verschiedene Objekte im Speicher)
        
        // hashCode() Vergleich
        System.out.println("max1.hashCode(): " + max1.hashCode());
        System.out.println("max2.hashCode(): " + max2.hashCode());
        // Verschiedene hashCodes!
        
        // In einem HashSet
        Set<PersonOhneEquals> personen = new HashSet<>();
        personen.add(max1);
        personen.add(max2);  // Sollte ignoriert werden (Duplikat)
        
        System.out.println("personen.size(): " + personen.size());
        // Erwartung: 1 (Duplikat)
        // Realität: 2 (beide drin - FALSCH!)
        
        System.out.println("⚠️ PROBLEM: Zwei 'Max Müller' im Set!");
        System.out.println("   Java erkennt sie nicht als Duplikate.");
    }
}
