package de.javafleet.collections;

/**
 * Java Erweiterte Techniken - Tag 2: Sets & Maps
 * 
 * Willkommen zu Tag 2! 🚀
 * 
 * In diesem Projekt lernst du:
 * - Set-Implementierungen (HashSet, LinkedHashSet, TreeSet)
 * - Map-Implementierungen (HashMap, TreeMap)
 * - Warum equals() und hashCode() so wichtig sind
 * - Comparable und Comparator für Sortierung
 * 
 * @author Java Fleet Systems Consulting
 * @version 1.0.0
 */
public class Main {
    
    public static void main(String[] args) {
        System.out.println("╔══════════════════════════════════════════════════════════╗");
        System.out.println("║  Java Erweiterte Techniken - Tag 2: Sets & Maps          ║");
        System.out.println("║  Java Fleet Systems Consulting                           ║");
        System.out.println("╚══════════════════════════════════════════════════════════╝");
        System.out.println();
        
        System.out.println("=== 1. Das Problem OHNE equals/hashCode ===");
        EqualsHashCodeProblem.demo();
        
        System.out.println();
        System.out.println("=== 2. Die Lösung MIT equals/hashCode ===");
        EqualsHashCodeLoesung.demo();
        
        System.out.println();
        System.out.println("=== 3. Set-Implementierungen ===");
        SetDemo.demo();
        
        System.out.println();
        System.out.println("=== 4. Map-Grundlagen ===");
        MapDemo.demo();
        
        System.out.println();
        System.out.println("=== 5. TreeSet mit Comparable/Comparator ===");
        SortierungDemo.demo();
        
        System.out.println();
        System.out.println("=== 6. Deine Challenge: Student-Klasse ===");
        System.out.println("Öffne die Klasse 'Student' und implementiere die TODOs!");
        System.out.println();
        
        // Uncomment um deine Student-Klasse zu testen:
        // StudentChallenge.demo();
        
        System.out.println("────────────────────────────────────────────────────────────");
        System.out.println("Geschafft! Weiter geht's mit Tag 3: Generics");
        System.out.println("Fragen? elyndra@java-developer.online");
    }
}
