package de.javafleet.collections;

/**
 * Person OHNE equals() und hashCode() - DAS IST EIN PROBLEM!
 * 
 * Diese Klasse zeigt, was passiert, wenn du equals/hashCode nicht überschreibst.
 * Ohne diese Methoden verwendet Java die Standard-Implementierung von Object:
 * - equals() prüft nur auf Referenzgleichheit (==)
 * - hashCode() basiert auf der Speicheradresse
 * 
 * Das bedeutet: Zwei Objekte mit gleichen Werten werden als UNTERSCHIEDLICH betrachtet!
 */
public class PersonOhneEquals {
    
    private String vorname;
    private String nachname;
    
    public PersonOhneEquals(String vorname, String nachname) {
        this.vorname = vorname;
        this.nachname = nachname;
    }
    
    public String getVorname() {
        return vorname;
    }
    
    public String getNachname() {
        return nachname;
    }
    
    @Override
    public String toString() {
        return vorname + " " + nachname;
    }
    
    // ⚠️ ACHTUNG: Hier fehlen equals() und hashCode()!
    // Das führt zu Problemen mit HashSet, HashMap, etc.
}
