package de.javafleet.collections;

/**
 * 🎨 CHALLENGE: Student-Klasse
 * 
 * Deine Aufgabe: Implementiere eine Student-Klasse mit korrektem
 * equals(), hashCode() und Comparable!
 * 
 * Level 1 (🟢 Einsteiger):
 * - Implementiere equals() und hashCode()
 * - Zwei Studenten sind gleich, wenn matrikelnummer gleich ist
 * 
 * Level 2 (🟡 Fortgeschritten):
 * - Implementiere Comparable<Student>
 * - Sortiere nach Nachname, dann Vorname
 * 
 * Level 3 (🔵 Profi):
 * - Erstelle zusätzlich einen Comparator für Sortierung nach Note (beste zuerst)
 * - Implementiere toString() für schöne Ausgabe
 * 
 * Tipp von Elyndra: "Die IDE kann equals/hashCode generieren.
 * Aber versteh, was der Code macht – sonst findest du Bugs nie!"
 */
public class Student {
    
    private int matrikelnummer;
    private String vorname;
    private String nachname;
    private double note;  // 1.0 bis 5.0
    
    public Student(int matrikelnummer, String vorname, String nachname, double note) {
        this.matrikelnummer = matrikelnummer;
        this.vorname = vorname;
        this.nachname = nachname;
        this.note = note;
    }
    
    // Getter
    public int getMatrikelnummer() {
        return matrikelnummer;
    }
    
    public String getVorname() {
        return vorname;
    }
    
    public String getNachname() {
        return nachname;
    }
    
    public double getNote() {
        return note;
    }
    
    /**
     * TODO Level 1: Implementiere equals()
     * 
     * Zwei Studenten sind gleich, wenn ihre Matrikelnummer gleich ist.
     * (Name und Note sind egal für Gleichheit!)
     * 
     * Hinweise:
     * 1. Prüfe erst auf Identität (this == o)
     * 2. Prüfe auf null und gleichen Typ
     * 3. Vergleiche die matrikelnummer
     */
    @Override
    public boolean equals(Object o) {
        // TODO: Implementiere diese Methode!
        //
        // Schritte:
        // 1. if (this == o) return true;
        // 2. if (o == null || getClass() != o.getClass()) return false;
        // 3. Student student = (Student) o;
        // 4. return matrikelnummer == student.matrikelnummer;
        //
        // Dein Code hier:
        
        return false;  // Placeholder - entfernen!
    }
    
    /**
     * TODO Level 1: Implementiere hashCode()
     * 
     * Der hashCode MUSS auf denselben Feldern basieren wie equals()!
     * Also nur auf matrikelnummer.
     * 
     * Hinweis: Für primitive int kannst du einfach den Wert zurückgeben,
     * oder Integer.hashCode(matrikelnummer) verwenden.
     */
    @Override
    public int hashCode() {
        // TODO: Implementiere diese Methode!
        //
        // Einfachste Lösung:
        // return Integer.hashCode(matrikelnummer);
        //
        // Oder mit Objects.hash():
        // return Objects.hash(matrikelnummer);
        //
        // Dein Code hier:
        
        return 0;  // Placeholder - entfernen!
    }
    
    /**
     * TODO Level 2: Implementiere Comparable<Student>
     * 
     * Sortiere Studenten nach:
     * 1. Nachname (alphabetisch)
     * 2. Bei gleichem Nachnamen: Vorname (alphabetisch)
     * 
     * Hinweis: Du musst auch "implements Comparable<Student>" 
     * zur Klassendeklaration hinzufügen!
     */
    // TODO: Füge "implements Comparable<Student>" zur Klasse hinzu
    // und implementiere diese Methode:
    //
    // @Override
    // public int compareTo(Student other) {
    //     int nachnameCompare = this.nachname.compareTo(other.nachname);
    //     if (nachnameCompare != 0) {
    //         return nachnameCompare;
    //     }
    //     return this.vorname.compareTo(other.vorname);
    // }
    
    /**
     * TODO Level 3: toString() für schöne Ausgabe
     * 
     * Format: "Max Müller (12345) - Note: 1.7"
     */
    @Override
    public String toString() {
        // TODO: Implementiere diese Methode!
        //
        // return vorname + " " + nachname + " (" + matrikelnummer + ") - Note: " + note;
        
        return "Student@" + hashCode();  // Placeholder
    }
    
    /**
     * TODO Level 3 BONUS: Comparator für Sortierung nach Note
     * 
     * Erstelle einen statischen Comparator der nach Note sortiert
     * (beste Note = 1.0 zuerst)
     * 
     * Hinweis: Comparator.comparingDouble(Student::getNote)
     */
    // public static final Comparator<Student> NACH_NOTE = 
    //     Comparator.comparingDouble(Student::getNote);
}
